/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.profile.simple;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.ebpm.profile.simple.FileWatcher;
import org.eclipse.ebpm.startup.service.IStartedUpService;
import org.eclipse.ebpm.workflow.api.IProfileService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfileService
implements IProfileService {
    private static Logger logger = LoggerFactory.getLogger(DefaultProfileService.class);
    protected List<String> dynamicRouting = new ArrayList<String>();
    protected String profilesFileName = "userprofile.xml";
    protected Timer timer = null;
    private Map<String, List<String>> userRolesMap = new HashMap<String, List<String>>();
    private File f = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProfiles() {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(this.f);
            Element authorizationsElement = doc.getRootElement();
            Element entitiesEl = authorizationsElement.element("ENTITIES");
            Element usersEl = entitiesEl.element("USERS");
            Element relationsEl = authorizationsElement.element("RELATIONS");
            Element behavioursEl = relationsEl.element("BEHAVIOURS");
            List users = usersEl.elements("USER");
            List behaviours = behavioursEl.elements("BEHAVIOUR");
            Map<String, List<String>> map = this.userRolesMap;
            synchronized (map) {
                this.userRolesMap = new HashMap<String, List<String>>();
                for (Element user : users) {
                    String name = user.attributeValue("userID");
                    ArrayList<String> roles = new ArrayList<String>();
                    for (Element behaviour : behaviours) {
                        String userid = behaviour.attributeValue("userID");
                        String role = behaviour.attributeValue("roleName");
                        if (!userid.equals(name)) continue;
                        roles.add(role);
                    }
                    if (roles.size() <= 0) continue;
                    this.userRolesMap.put(name, roles);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void activate(ComponentContext componentContext) {
        String spagicHome = System.getProperty("spagic.home");
        String authFile = String.valueOf(spagicHome) + File.separator + this.profilesFileName;
        this.f = new File(authFile);
        this.loadProfiles();
        FileWatcher task = new FileWatcher(this.f){

            @Override
            protected void onChange(File file) {
                DefaultProfileService.this.loadProfiles();
            }
        };
        this.timer = new Timer();
        this.timer.schedule((TimerTask)task, new Date(), 5000L);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.timer.cancel();
    }

    public List<String> getUserRoles(String actorId) {
        if (this.userRolesMap.containsKey(actorId)) {
            return this.userRolesMap.get(actorId);
        }
        return new ArrayList<String>();
    }

    public List<String> getUsers() {
        ArrayList<String> users = new ArrayList<String>();
        users.addAll(this.userRolesMap.keySet());
        return users;
    }

    public void bindStartUpService(IStartedUpService startedUpService) {
        logger.info("STARTUP SERVICE IS OK -> CAN START PROFILE SERVICE");
    }

    public void unbindStartUpService(IStartedUpService startedUpService) {
    }
}

