/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.messaging.core.util;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;

public class StringSource
extends StreamSource
implements Externalizable {
    private String text;
    private String encoding = "UTF-8";
    private static final int SINGLE_PART_SIZE_K = 16384;
    private static final byte NULL = 0;
    private static final byte NOT_NULL = 1;

    public StringSource() {
    }

    public StringSource(String text) {
        if (text == null) {
            throw new NullPointerException("text can not be null");
        }
        this.text = text;
    }

    public StringSource(String text, String systemId) {
        this(text);
        this.setSystemId(systemId);
    }

    public StringSource(String text, String systemId, String encoding) {
        this.text = text;
        this.encoding = encoding;
        this.setSystemId(systemId);
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new ByteArrayInputStream(this.text.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.text);
    }

    public String toString() {
        return "StringSource[" + this.text + "]";
    }

    public String getText() {
        return this.text;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.text != null) {
            out.writeByte(1);
        } else {
            out.write(0);
        }
        if (this.encoding != null) {
            out.writeByte(1);
        } else {
            out.writeByte(0);
        }
        if (this.getSystemId() != null) {
            out.writeByte(1);
        } else {
            out.writeByte(0);
        }
        if (this.text != null) {
            this.writeText(out, this.text);
        } else {
            out.writeUTF("TEXT_NULL");
        }
        if (this.encoding != null) {
            out.writeUTF(this.encoding);
        } else {
            out.writeUTF("TEXT_NULL");
        }
        if (this.getSystemId() != null) {
            out.writeUTF(this.getSystemId());
        } else {
            out.writeUTF("SYSTEM_ID_NULL");
        }
    }

    public void writeText(ObjectOutput out, String text) throws IOException {
        int textSize = text.length();
        int parts_length = textSize == 0 ? 0 : (int)((short)((textSize - 1) / 16384 + 1));
        out.writeShort(parts_length);
        int i = 0;
        while (textSize > 0) {
            int beginCopy = i * 16384;
            int endCopy = textSize <= 16384 ? beginCopy + textSize : beginCopy + 16384;
            String theChunk = text.substring(beginCopy, endCopy);
            out.writeUTF(theChunk);
            textSize -= 16384;
            ++i;
        }
    }

    public String readText(ObjectInput in) throws IOException {
        int parts_length = in.readShort();
        int bufferSize = 16384 * parts_length;
        if (parts_length == 1) {
            int inSize = in.available();
            if (inSize <= 0) {
                inSize = 256;
            }
            bufferSize = Math.min(inSize, bufferSize);
        }
        StringBuffer buff = new StringBuffer(bufferSize);
        int i = 0;
        while (i < parts_length) {
            String s = in.readUTF();
            buff.append(s);
            ++i;
        }
        return buff.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean textIsNull = in.readByte() == 0;
        boolean econdingIsNull = in.readByte() == 0;
        boolean systemIdIsNull = in.readByte() == 0;
        String textTemp = this.readText(in);
        String encodingTemp = in.readUTF();
        String systemIdtemp = in.readUTF();
        if (!textIsNull) {
            this.text = textTemp;
        }
        if (!econdingIsNull) {
            this.encoding = encodingTemp;
        }
        if (!systemIdIsNull) {
            this.setSystemId(systemIdtemp);
        }
    }
}

