/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.tools.CompressTool;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.TempFileDeleter;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptBase
extends Prepared
implements DataHandler {
    protected OutputStream out;
    protected InputStream in;
    private Expression fileNameExpr;
    private String fileName;
    private String cipher;
    private byte[] key;
    private FileStore store;
    private String compressionAlgorithm;

    public ScriptBase(Session session) {
        super(session);
    }

    public void setCipher(String string) {
        this.cipher = string;
    }

    private boolean isEncrypted() {
        return this.cipher != null;
    }

    public void setPassword(char[] cArray) {
        SHA256 sHA256 = new SHA256();
        this.key = sHA256.getKeyPasswordHash("script", cArray);
    }

    public void setFileNameExpr(Expression expression) {
        this.fileNameExpr = expression;
    }

    protected String getFileName() throws SQLException {
        if (this.fileNameExpr != null && this.fileName == null) {
            this.fileName = this.fileNameExpr.optimize(this.session).getValue(this.session).getString();
            if (this.fileName == null || this.fileName.trim().length() == 0) {
                this.fileName = "script.sql";
            }
            this.fileName = SysProperties.getScriptDirectory() + this.fileName;
        }
        return this.fileName;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    void deleteStore() throws SQLException {
        String string = this.getFileName();
        if (string != null) {
            FileUtils.delete(string);
        }
    }

    private void initStore() throws SQLException {
        Database database = this.session.getDatabase();
        String string = this.getFileName();
        this.store = FileStore.open(database, string, "rw", this.cipher, this.key);
        this.store.setCheckedWriting(false);
        this.store.init();
    }

    void openOutput() throws SQLException {
        String string = this.getFileName();
        if (string == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.out = new FileStoreOutputStream(this.store, this, this.compressionAlgorithm);
            this.out = new BufferedOutputStream(this.out, 131072);
        } else {
            OutputStream outputStream = FileUtils.openFileOutputStream(string, false);
            this.out = new BufferedOutputStream(outputStream, 4096);
            this.out = CompressTool.wrapOutputStream(this.out, this.compressionAlgorithm, "script.sql");
        }
    }

    void openInput() throws SQLException {
        String string = this.getFileName();
        if (string == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.in = new FileStoreInputStream(this.store, this, this.compressionAlgorithm != null, false);
        } else {
            InputStream inputStream;
            try {
                inputStream = FileUtils.openFileInputStream(string);
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, string);
            }
            this.in = new BufferedInputStream(inputStream, 4096);
            this.in = CompressTool.wrapInputStream(this.in, this.compressionAlgorithm, "script.sql");
            if (this.in == null) {
                throw Message.getSQLException(90124, "script.sql in " + string);
            }
        }
    }

    void closeIO() {
        IOUtils.closeSilently(this.out);
        this.out = null;
        IOUtils.closeSilently(this.in);
        this.in = null;
        if (this.store != null) {
            this.store.closeSilently();
            this.store = null;
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public String getDatabasePath() {
        return null;
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        return null;
    }

    @Override
    public int getChecksum(byte[] byArray, int n, int n2) {
        return this.session.getDatabase().getChecksum(byArray, n, n2);
    }

    @Override
    public void checkPowerOff() throws SQLException {
        this.session.getDatabase().checkPowerOff();
    }

    @Override
    public void checkWritingAllowed() throws SQLException {
        this.session.getDatabase().checkWritingAllowed();
    }

    @Override
    public void freeUpDiskSpace() throws SQLException {
        this.session.getDatabase().freeUpDiskSpace();
    }

    @Override
    public void handleInvalidChecksum() throws SQLException {
        this.session.getDatabase().handleInvalidChecksum();
    }

    @Override
    public int compareTypeSave(Value value, Value value2) {
        throw Message.throwInternalError();
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.session.getDatabase().getMaxLengthInplaceLob();
    }

    @Override
    public int allocateObjectId(boolean bl, boolean bl2) {
        return this.session.getDatabase().allocateObjectId(bl, bl2);
    }

    @Override
    public String createTempFile() throws SQLException {
        return this.session.getDatabase().createTempFile();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.session.getDatabase().getTempFileDeleter();
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return this.session.getDatabase().getLobCompressionAlgorithm(n);
    }

    public void setCompressionAlgorithm(String string) {
        this.compressionAlgorithm = string;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public boolean getLobFilesInDirectories() {
        return this.session.getDatabase().getLobFilesInDirectories();
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public Trace getTrace() {
        return this.session.getDatabase().getTrace("database");
    }
}

