/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.filter;

import ch.qos.logback.access.filter.CountingFilter;
import ch.qos.logback.access.filter.StatisticalView;
import ch.qos.logback.access.filter.StatsByDay;
import ch.qos.logback.access.filter.StatsByHour;
import ch.qos.logback.access.filter.StatsByMinute;
import ch.qos.logback.access.filter.StatsByMonth;
import ch.qos.logback.access.filter.StatsByWeek;
import ch.qos.logback.core.spi.LifeCycle;

public class StatisticalViewImpl
implements StatisticalView,
LifeCycle {
    final CountingFilter countingFilter;
    boolean started;
    StatsByMinute statsByMinute = new StatsByMinute();
    StatsByHour statsByHour = new StatsByHour();
    StatsByDay statsByDay = new StatsByDay();
    StatsByWeek statsByWeek = new StatsByWeek();
    StatsByMonth statsByMonth = new StatsByMonth();

    StatisticalViewImpl(CountingFilter countingFilter) {
        this.countingFilter = countingFilter;
    }

    public double getDailyAverage() {
        return this.statsByDay.getAverage();
    }

    public long getLastDaysCount() {
        return this.statsByDay.getLastCount();
    }

    public double getMonthlyAverage() {
        return this.statsByMonth.getAverage();
    }

    public long getLastMonthsCount() {
        return this.statsByMonth.getLastCount();
    }

    public long getTotal() {
        return this.countingFilter.getTotal();
    }

    public double getWeeklyAverage() {
        return this.statsByWeek.getAverage();
    }

    public long getLastWeeksCount() {
        return this.statsByWeek.getLastCount();
    }

    void update(long now) {
        long total = this.getTotal();
        this.statsByMinute.update(now, total);
        this.statsByHour.update(now, total);
        this.statsByDay.update(now, total);
        this.statsByWeek.update(now, total);
        this.statsByMonth.update(now, total);
    }

    void update() {
        long now = System.currentTimeMillis();
        this.update(now);
    }

    public void start() {
        System.out.println("StatisticalViewImpl start called");
        this.started = true;
        long now = System.currentTimeMillis();
        this.statsByMinute = new StatsByMinute(now);
        this.statsByHour = new StatsByHour(now);
        this.statsByDay = new StatsByDay(now);
        this.statsByWeek = new StatsByWeek(now);
        this.statsByMonth = new StatsByMonth(now);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        this.started = false;
        this.statsByMinute.reset();
        this.statsByHour.reset();
        this.statsByDay.reset();
        this.statsByWeek.reset();
        this.statsByMonth.reset();
    }

    public long getLastMinuteCount() {
        return this.statsByMinute.getLastCount();
    }

    public double getMinuteAverage() {
        return this.statsByMinute.getAverage();
    }

    public double getHourlyAverage() {
        return this.statsByHour.getAverage();
    }

    public long getLastHoursCount() {
        return this.statsByHour.getLastCount();
    }
}

