/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;

public class DoubleBufferingOutputStream
extends FilterOutputStream {
    protected ExecutorService _pool = Executors.newSingleThreadExecutor();
    protected Future<?>[] _locks;
    protected byte[][] _buff;
    private int _pos;

    public DoubleBufferingOutputStream(OutputStream out) {
        this(out, 2, 8192);
    }

    public DoubleBufferingOutputStream(OutputStream out, int num, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0.");
        }
        if (size % 8 != 0) {
            throw new IllegalArgumentException("Buffer size not a multiple of 8.");
        }
        this._buff = new byte[num][size];
        this._locks = new Future[num];
        for (int i = 0; i < num; ++i) {
            this._locks[i] = ConcurrentUtils.constantFuture(null);
        }
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            byte[][] byArray = this._buff;
            synchronized (this._buff) {
                this._locks[this._pos].get();
                System.arraycopy(b, off, this._buff[this._pos], 0, len);
                this._locks[this._pos] = this._pool.submit(new WriteTask(this._buff[this._pos], len));
                this._pos = (this._pos + 1) % this._buff.length;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        {
            return;
        }
    }

    public void writeBuffer(byte[] b, int off, int len) {
        try {
            this.out.write(b, off, len);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            byte[][] byArray = this._buff;
            synchronized (this._buff) {
                for (int i = 0; i < this._buff.length; ++i) {
                    this._locks[i].get();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        {
            this.out.flush();
            return;
        }
    }

    @Override
    public void close() throws IOException {
        this._pool.shutdown();
        super.close();
    }

    private class WriteTask
    implements Callable<Object> {
        private final byte[] _b;
        private final int _len;

        protected WriteTask(byte[] buff, int len) {
            this._b = buff;
            this._len = len;
        }

        @Override
        public Object call() {
            DoubleBufferingOutputStream.this.writeBuffer(this._b, 0, this._len);
            return null;
        }
    }
}

