/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderBin;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderFeatureHash;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.runtime.util.DependencyTask;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.stats.TransformStatistics;

public class ColumnEncoderDummycode
extends ColumnEncoder {
    private static final long serialVersionUID = 5832130477659116489L;
    public int _domainSize = -1;

    public ColumnEncoderDummycode() {
        super(-1);
    }

    public ColumnEncoderDummycode(int colID) {
        super(colID);
    }

    public ColumnEncoderDummycode(int colID, int domainSize) {
        super(colID);
        this._domainSize = domainSize;
    }

    @Override
    protected ColumnEncoder.TransformType getTransformType() {
        return ColumnEncoder.TransformType.DUMMYCODE;
    }

    @Override
    public void build(CacheBlock<?> in) {
    }

    @Override
    public List<DependencyTask<?>> getBuildTasks(CacheBlock<?> in) {
        return null;
    }

    @Override
    protected double getCode(CacheBlock<?> in, int row) {
        throw new DMLRuntimeException("DummyCoder does not have a code");
    }

    @Override
    protected double[] getCodeCol(CacheBlock<?> in, int startInd, int endInd, double[] tmp) {
        throw new DMLRuntimeException("DummyCoder does not have a code");
    }

    @Override
    protected void applySparse(CacheBlock<?> in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        if (!(in instanceof MatrixBlock)) {
            throw new DMLRuntimeException("ColumnEncoderDummycode called with: " + in.getClass().getSimpleName() + " and not MatrixBlock");
        }
        boolean mcsr = MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR;
        mcsr = false;
        ArrayList<Integer> sparseRowsWZeros = null;
        int index = this._colID - 1;
        for (int r = rowStart; r < UtilFunctions.getEndIndex(in.getNumRows(), rowStart, blk); ++r) {
            int nCol;
            if (mcsr) {
                int nCol2;
                double val = out.getSparseBlock().get(r).values()[index];
                if (Double.isNaN(val)) {
                    if (sparseRowsWZeros == null) {
                        sparseRowsWZeros = new ArrayList<Integer>();
                    }
                    sparseRowsWZeros.add(r);
                    out.getSparseBlock().get((int)r).values()[index] = 0.0;
                    continue;
                }
                out.getSparseBlock().get((int)r).indexes()[index] = nCol2 = outputCol + (int)val - 1;
                out.getSparseBlock().get((int)r).values()[index] = 1.0;
                continue;
            }
            SparseBlockCSR csrblock = (SparseBlockCSR)out.getSparseBlock();
            int[] rptr = csrblock.rowPointers();
            double val = csrblock.values()[rptr[r] + index];
            if (Double.isNaN(val)) {
                if (sparseRowsWZeros == null) {
                    sparseRowsWZeros = new ArrayList();
                }
                sparseRowsWZeros.add(r);
                csrblock.values()[rptr[r] + index] = 0.0;
                continue;
            }
            csrblock.indexes()[rptr[r] + index] = nCol = outputCol + (int)val - 1;
            csrblock.values()[rptr[r] + index] = 1.0;
        }
        if (sparseRowsWZeros != null) {
            this.addSparseRowsWZeros(sparseRowsWZeros);
        }
    }

    @Override
    protected void applyDense(CacheBlock<?> in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        if (!(in instanceof MatrixBlock)) {
            throw new DMLRuntimeException("ColumnEncoderDummycode called with: " + in.getClass().getSimpleName() + " and not MatrixBlock");
        }
        int rowEnd = UtilFunctions.getEndIndex(in.getNumRows(), rowStart, blk);
        double[] vals = new double[rowEnd - rowStart];
        for (int i = rowStart; i < rowEnd; ++i) {
            vals[i - rowStart] = in.getDouble(i, outputCol);
        }
        int B = 32;
        for (int i = rowStart; i < rowEnd; i += B) {
            int lim = Math.min(i + B, rowEnd);
            for (int ii = i; ii < lim; ++ii) {
                double val = vals[ii - rowStart];
                if (Double.isNaN(val)) {
                    out.quickSetValue(ii, outputCol, 0.0);
                    continue;
                }
                int nCol = outputCol + (int)val - 1;
                if (nCol != outputCol) {
                    out.quickSetValue(ii, outputCol, 0.0);
                }
                out.quickSetValue(ii, nCol, 1.0);
            }
        }
    }

    @Override
    protected ColumnEncoder.ColumnApplyTask<? extends ColumnEncoder> getSparseTask(CacheBlock<?> in, MatrixBlock out, int outputCol, int startRow, int blk) {
        if (!(in instanceof MatrixBlock)) {
            throw new DMLRuntimeException("ColumnEncoderDummycode called with: " + in.getClass().getSimpleName() + " and not MatrixBlock");
        }
        return new DummycodeSparseApplyTask(this, (MatrixBlock)in, out, outputCol, startRow, blk);
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (other instanceof ColumnEncoderDummycode) {
            assert (other._colID == this._colID);
            this._domainSize = 0;
            return;
        }
        super.mergeAt(other);
    }

    @Override
    public void updateIndexRanges(long[] beginDims, long[] endDims, int colOffset) {
        beginDims[1] = beginDims[1] + (long)colOffset;
        endDims[1] = endDims[1] + (long)(this._domainSize - 1 + colOffset);
    }

    public void updateDomainSizes(List<ColumnEncoder> columnEncoders) {
        if (this._colID == -1) {
            return;
        }
        for (ColumnEncoder columnEncoder : columnEncoders) {
            int distinct = -1;
            if (columnEncoder instanceof ColumnEncoderRecode) {
                ColumnEncoderRecode columnEncoderRecode = (ColumnEncoderRecode)columnEncoder;
                distinct = columnEncoderRecode.getNumDistinctValues();
            } else if (columnEncoder instanceof ColumnEncoderBin) {
                distinct = ((ColumnEncoderBin)columnEncoder)._numBin;
            } else if (columnEncoder instanceof ColumnEncoderFeatureHash) {
                distinct = (int)((ColumnEncoderFeatureHash)columnEncoder).getK();
            }
            if (distinct == -1) continue;
            this._domainSize = Math.max(1, distinct);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("DummyCoder for column: " + this._colID + " has domain size: " + this._domainSize));
        }
    }

    @Override
    public void allocateMetaData(FrameBlock meta) {
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._domainSize = Math.max(1, (int)meta.getColumnMetadata()[this._colID - 1].getNumDistinct());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this._domainSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        this._domainSize = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnEncoderDummycode that = (ColumnEncoderDummycode)o;
        return this._colID == that._colID && this._domainSize == that._domainSize;
    }

    public int hashCode() {
        int result = Objects.hash(this._colID);
        result = 31 * result + Objects.hashCode(this._domainSize);
        return result;
    }

    @Override
    public int getDomainSize() {
        return this._domainSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(": ");
        sb.append(this._colID);
        sb.append(" --- DomainSize : ");
        sb.append(this._domainSize);
        return sb.toString();
    }

    private static class DummycodeSparseApplyTask
    extends ColumnEncoder.ColumnApplyTask<ColumnEncoderDummycode> {
        protected DummycodeSparseApplyTask(ColumnEncoderDummycode encoder, MatrixBlock input, MatrixBlock out, int outputCol) {
            super(encoder, input, out, outputCol);
        }

        protected DummycodeSparseApplyTask(ColumnEncoderDummycode encoder, MatrixBlock input, MatrixBlock out, int outputCol, int startRow, int blk) {
            super(encoder, input, out, outputCol, startRow, blk);
        }

        @Override
        public Object call() throws Exception {
            long t0;
            long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            if (this._out.getSparseBlock() == null) {
                return null;
            }
            ((ColumnEncoderDummycode)this._encoder).applySparse(this._input, this._out, this._outputCol, this._startRow, this._blk);
            if (DMLScript.STATISTICS) {
                TransformStatistics.incDummyCodeApplyTime(System.nanoTime() - t0);
            }
            return null;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "<ColId: " + ((ColumnEncoderDummycode)this._encoder)._colID + ">";
        }
    }
}

