/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class OffsetChar
extends AOffset {
    private static final long serialVersionUID = -1192266421395964882L;
    private static final int maxV = 65535;
    private final char[] offsets;
    private final int offsetToFirst;

    public OffsetChar(int[] indexes) {
        this(indexes, 0, indexes.length);
    }

    public OffsetChar(int[] indexes, int apos, int alen) {
        int endSize = 0;
        int ov = this.offsetToFirst = indexes[apos];
        for (int i = apos + 1; i < alen; ++i) {
            int nv = indexes[i];
            endSize += 1 + (nv - ov) / 65535;
            ov = nv;
        }
        this.offsets = new char[endSize];
        ov = this.offsetToFirst;
        int p = 0;
        for (int i = apos + 1; i < alen; ++i) {
            int nv = indexes[i];
            int offsetSize = nv - ov;
            if (offsetSize == 0) {
                throw new DMLCompressionException("Invalid difference between cells :\n" + Arrays.toString(indexes));
            }
            int div = offsetSize / 65535;
            int mod = offsetSize % 65535;
            if (mod == 0) {
                p += div - 1;
                this.offsets[p++] = 65535;
            } else {
                p += div;
                this.offsets[p++] = (char)mod;
            }
            ov = nv;
        }
    }

    private OffsetChar(char[] offsets, int offsetToFirst) {
        this.offsets = offsets;
        this.offsetToFirst = offsetToFirst;
    }

    @Override
    public IterateCharOffset getIterator() {
        return new IterateCharOffset();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(OffsetFactory.OFF_TYPE.CHAR.ordinal());
        out.writeInt(this.offsetToFirst);
        out.writeInt(this.offsets.length);
        for (char o : this.offsets) {
            out.writeChar(o);
        }
    }

    @Override
    public long getInMemorySize() {
        return OffsetChar.getInMemorySize(this.offsets.length);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this.offsets.length * 2;
    }

    @Override
    public int getSize() {
        int size = 1;
        for (char b : this.offsets) {
            if (b == '\u0000') continue;
            ++size;
        }
        return size;
    }

    public static OffsetChar readFields(DataInput in) throws IOException {
        int offsetToFirst = in.readInt();
        int offsetsLength = in.readInt();
        char[] offsets = new char[offsetsLength];
        for (int i = 0; i < offsetsLength; ++i) {
            offsets[i] = in.readChar();
        }
        return new OffsetChar(offsets, offsetToFirst);
    }

    public static long getInMemorySize(int length) {
        long size = 28L;
        return size += MemoryEstimates.charArrayCost(length - 1);
    }

    private class IterateCharOffset
    extends AIterator {
        private IterateCharOffset() {
            super(0, 0, OffsetChar.this.offsetToFirst);
        }

        private IterateCharOffset(int index, int dataIndex, int offset) {
            super(index, dataIndex, offset);
        }

        @Override
        public void next() {
            if (this.index >= OffsetChar.this.offsets.length) {
                ++this.index;
                ++this.dataIndex;
                return;
            }
            char v = OffsetChar.this.offsets[this.index++];
            if (v == '\u0000') {
                this.offset += 65535;
                this.next();
            } else {
                ++this.dataIndex;
                this.offset += v;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index <= OffsetChar.this.offsets.length;
        }

        @Override
        public IterateCharOffset clone() {
            return new IterateCharOffset(this.index, this.dataIndex, this.offset);
        }
    }
}

