/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class ReaderWriterFederated {
    private static final Log LOG = LogFactory.getLog((String)ReaderWriterFederated.class.getName());

    public static List<Pair<FederatedRange, FederatedData>> read(String file, DataCharacteristics mc) {
        LOG.debug((Object)("Reading federated map from " + file));
        try {
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            Path path = new Path(file);
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            FSDataInputStream data = fs.open(path);
            ObjectMapper mapper = new ObjectMapper();
            List obj = (List)mapper.readValue((InputStream)data, (TypeReference)new TypeReference<List<FederatedDataAddress>>(){});
            return obj.stream().map(x -> x.convert()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Unable to read federated matrix (" + file + ")", e);
        }
    }

    public static void write(String file, FederationMap fedMap) {
        LOG.debug((Object)("Writing federated map to " + file));
        try {
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            Path path = new Path(file);
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            FSDataOutputStream out = fs.create(path, true);
            ObjectMapper mapper = new ObjectMapper();
            FederatedDataAddress[] outObjects = ReaderWriterFederated.parseMap(fedMap.getMap());
            try (BufferedWriter pw = new BufferedWriter(new OutputStreamWriter((OutputStream)out));){
                mapper.writeValue((Writer)pw, (Object)outObjects);
            }
            IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
        }
        catch (IOException e) {
            throw new DMLRuntimeException("Unable to write test federated matrix to (" + file + "): " + e.getMessage());
        }
    }

    private static FederatedDataAddress[] parseMap(List<Pair<FederatedRange, FederatedData>> map) {
        return (FederatedDataAddress[])map.stream().map(e -> new FederatedDataAddress((FederatedRange)e.getKey(), (FederatedData)e.getValue())).toArray(FederatedDataAddress[]::new);
    }

    private static class FederatedDataAddress {
        private Types.DataType _dataType;
        private InetSocketAddress _address;
        private String _filepath;
        private long[] _begin;
        private long[] _end;

        public FederatedDataAddress() {
        }

        protected FederatedDataAddress(FederatedRange fr, FederatedData fd) {
            this._dataType = fd.getDataType();
            this._address = fd.getAddress();
            this._filepath = fd.getFilepath();
            this._begin = fr.getBeginDims();
            this._end = fr.getEndDims();
        }

        protected Pair<FederatedRange, FederatedData> convert() {
            FederatedRange fr = new FederatedRange(this._begin, this._end);
            FederatedData fd = new FederatedData(this._dataType, this._address, this._filepath);
            return new ImmutablePair((Object)fr, (Object)fd);
        }

        public String getFilepath() {
            return this._filepath;
        }

        public void setFilepath(String filePath) {
            this._filepath = filePath;
        }

        public Types.DataType getDataType() {
            return this._dataType;
        }

        public void setDataType(Types.DataType dataType) {
            this._dataType = dataType;
        }

        public InetSocketAddress getAddress() {
            return this._address;
        }

        public void setAddress(InetSocketAddress address) {
            this._address = address;
        }

        public long[] getBegin() {
            return this._begin;
        }

        public void setBegin(long[] begin) {
            this._begin = begin;
        }

        public long[] getEnd() {
            return this._end;
        }

        public void setEnd(long[] end) {
            this._end = end;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this._dataType);
            sb.append(" ");
            sb.append(this._address);
            sb.append(" ");
            sb.append(this._filepath);
            sb.append(" ");
            sb.append(Arrays.toString(this._begin));
            sb.append(" ");
            sb.append(Arrays.toString(this._end));
            return sb.toString();
        }
    }
}

