/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.io.IOException;
import java.util.List;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.specific.AvroGenerated;

@AvroGenerated
public interface AvroTrace {
    public static final Protocol PROTOCOL = Protocol.parse((String)"{\"protocol\":\"AvroTrace\",\"namespace\":\"org.apache.avro.ipc.trace\",\"doc\":\"* A Span is our basic unit of tracing. It tracks the critical points\\n * of a single RPC call and records other call meta-data. It also\\n * allows arbitrary string annotations. Both the client and server create\\n * Span objects, each of which is populated with half of the relevant event\\n * data. They share a span ID, which allows us to merge them into one complete\\n * span later on.\",\"types\":[{\"type\":\"enum\",\"name\":\"SpanEvent\",\"symbols\":[\"SERVER_RECV\",\"SERVER_SEND\",\"CLIENT_RECV\",\"CLIENT_SEND\"]},{\"type\":\"fixed\",\"name\":\"ID\",\"size\":8},{\"type\":\"record\",\"name\":\"TimestampedEvent\",\"fields\":[{\"name\":\"timeStamp\",\"type\":\"long\"},{\"name\":\"event\",\"type\":[\"SpanEvent\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]}]},{\"type\":\"record\",\"name\":\"Span\",\"doc\":\"* An individual span is the basic unit of testing.\\n   * The record is used by both \\\\\\\"client\\\\\\\" and \\\\\\\"server\\\\\\\".\",\"fields\":[{\"name\":\"traceID\",\"type\":\"ID\"},{\"name\":\"spanID\",\"type\":\"ID\"},{\"name\":\"parentSpanID\",\"type\":[\"ID\",\"null\"]},{\"name\":\"messageName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"requestPayloadSize\",\"type\":\"long\"},{\"name\":\"responsePayloadSize\",\"type\":\"long\"},{\"name\":\"requestorHostname\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\"},\"null\"]},{\"name\":\"responderHostname\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\"},\"null\"]},{\"name\":\"events\",\"type\":{\"type\":\"array\",\"items\":\"TimestampedEvent\"}},{\"name\":\"complete\",\"type\":\"boolean\"}]}],\"messages\":{\"getAllSpans\":{\"doc\":\"* Get all spans stored on this host.\",\"request\":[],\"response\":{\"type\":\"array\",\"items\":\"Span\"}},\"getSpansInRange\":{\"doc\":\"* Get spans occuring between start and end. Each is a unix timestamp\\n   * in nanosecond units (for consistency with TimestampedEvent).\",\"request\":[{\"name\":\"start\",\"type\":\"long\"},{\"name\":\"end\",\"type\":\"long\"}],\"response\":{\"type\":\"array\",\"items\":\"Span\"}}}}");

    public List<Span> getAllSpans() throws AvroRemoteException;

    public List<Span> getSpansInRange(long var1, long var3) throws AvroRemoteException;

    public static interface Callback
    extends AvroTrace {
        public static final Protocol PROTOCOL = PROTOCOL;

        public void getAllSpans(org.apache.avro.ipc.Callback<List<Span>> var1) throws IOException;

        public void getSpansInRange(long var1, long var3, org.apache.avro.ipc.Callback<List<Span>> var5) throws IOException;
    }
}

