/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resourceresolver.impl.mapping.QueryBuildHelper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedQueryIterator
implements Iterator<Resource> {
    private final Logger log = LoggerFactory.getLogger(PagedQueryIterator.class);
    private final String subject;
    private final String propertyName;
    private final ResourceResolver resolver;
    private final String query;
    private final int pageSize;
    private final String[] defaultValue = new String[0];
    private String lastKey = "";
    private String lastValue = null;
    private Iterator<Resource> it;
    private int count = 0;
    private int page = 0;
    private Resource next = null;
    private int largestPage = 0;
    private String largestKeyValue = "";
    private int largestKeyCount = 0;
    private int currentKeyCount = 0;

    public PagedQueryIterator(String subject, String propertyName, ResourceResolver resolver, String query, int pageSize) {
        this.subject = subject;
        this.propertyName = propertyName;
        this.resolver = resolver;
        this.query = query;
        this.pageSize = pageSize;
        this.nextPage();
    }

    private void nextPage() {
        this.count = 0;
        String formattedQuery = String.format(this.query, QueryBuildHelper.escapeString(this.lastKey));
        this.log.debug("start {} query (page {}): {}", new Object[]{this.subject, this.page, formattedQuery});
        long queryStart = System.nanoTime();
        this.it = this.resolver.findResources(formattedQuery, "JCR-SQL2");
        long queryElapsed = System.nanoTime() - queryStart;
        this.log.debug("end {} query (page {}); elapsed {}ms", new Object[]{this.subject, this.page, TimeUnit.NANOSECONDS.toMillis(queryElapsed)});
        ++this.page;
    }

    private Resource getNext() throws NoSuchElementException {
        Resource resource = this.it.next();
        ++this.count;
        String[] values = (String[])resource.getValueMap().get(this.propertyName, (Object)this.defaultValue);
        if (values.length > 0) {
            String value = values[0];
            if (value.compareTo(this.lastKey) < 0) {
                String message = String.format("unexpected query result in page %d, property name '%s', got '%s', despite querying for > '%s'", this.page - 1, this.propertyName, value, this.lastKey);
                this.log.error(message);
                throw new QueryImplementationException(message);
            }
            if (this.lastValue != null && value.compareTo(this.lastValue) < 0) {
                String message = String.format("unexpected query result in page %d, property name '%s', got '%s', last value was '%s'", this.page - 1, this.propertyName, value, this.lastValue);
                this.log.error(message);
                throw new QueryImplementationException(message);
            }
            if (value.equals(this.lastValue)) {
                ++this.currentKeyCount;
            } else {
                if (this.currentKeyCount > this.largestKeyCount) {
                    this.largestKeyCount = this.currentKeyCount + 1;
                    this.largestKeyValue = this.lastValue;
                }
                this.currentKeyCount = 0;
            }
            if (this.count > this.pageSize && !value.equals(this.lastValue)) {
                this.updatePageStats();
                this.lastKey = value;
                this.nextPage();
                return this.getNext();
            }
            this.lastValue = value;
        }
        return resource;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            try {
                this.next = this.getNext();
            }
            catch (NoSuchElementException ex) {
                if (this.currentKeyCount > this.largestKeyCount) {
                    this.largestKeyCount = this.currentKeyCount + 1;
                    this.largestKeyValue = this.lastValue;
                }
                this.updatePageStats();
                this.next = null;
            }
        }
        return this.next != null;
    }

    @Override
    public Resource next() throws NoSuchElementException {
        Resource result = this.next != null ? this.next : this.getNext();
        this.next = null;
        return result;
    }

    private void updatePageStats() {
        this.largestPage = Math.max(this.largestPage, this.count - 1);
        this.log.debug("read {} query (page {}); {} entries, last key was: {}, largest page so far: {}", new Object[]{this.subject, this.page - 1, this.count, this.lastKey, this.largestPage});
    }

    @NotNull
    public String getStatistics() {
        return String.format(" (max. page size: %d, number of pages: %d)", this.largestPage, this.page);
    }

    @NotNull
    public String getWarning() {
        int warnAt = this.pageSize * 10;
        if (this.largestKeyCount > warnAt) {
            return String.format("Largest number of %s entries with the same 'first' selector exceeds expectation of %d (value '%s' appears %d times)", this.subject, warnAt, this.largestKeyValue, this.largestKeyCount);
        }
        return "";
    }

    public static class QueryImplementationException
    extends RuntimeException {
        public QueryImplementationException(String message) {
            super(message);
        }
    }
}

