/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.DefaultExceptionProcessor;
import org.apache.servicecomb.core.exception.ExceptionProcessor;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Exceptions {
    private static ExceptionProcessor processor = new DefaultExceptionProcessor();

    @Autowired(required=false)
    public void setProcessor(List<ExceptionProcessor> processors) {
        processor = processors.stream().min(Comparator.comparingInt(ExceptionProcessor::getOrder)).orElse(new DefaultExceptionProcessor());
    }

    public static Throwable unwrapIncludeInvocationException(Throwable throwable) {
        return ExceptionFactory.unwrapIncludeInvocationException((Throwable)throwable);
    }

    public static <T extends Throwable> T unwrap(Throwable throwable) {
        return (T)ExceptionFactory.unwrap((Throwable)throwable);
    }

    public static InvocationException create(Response.StatusType status, Object errorData) {
        return new InvocationException(status, errorData);
    }

    public static InvocationException create(Response.StatusType status, String code, String msg) {
        return new InvocationException(status, code, msg);
    }

    private static InvocationException create(Response.StatusType status, String code, String msg, Throwable cause) {
        return new InvocationException(status, code, msg, cause);
    }

    public static InvocationException consumer(String code, String msg) {
        return Exceptions.create((Response.StatusType)Response.Status.BAD_REQUEST, code, msg);
    }

    public static InvocationException consumer(String code, String msg, Throwable cause) {
        return Exceptions.create((Response.StatusType)Response.Status.BAD_REQUEST, code, msg, cause);
    }

    public static InvocationException genericConsumer(String msg) {
        return Exceptions.consumer("SCB.00000000", msg);
    }

    public static InvocationException genericConsumer(String msg, Throwable cause) {
        return Exceptions.consumer("SCB.00000000", msg, cause);
    }

    public static InvocationException producer(String code, String msg) {
        return Exceptions.create((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, code, msg);
    }

    public static InvocationException producer(String code, String msg, Throwable cause) {
        return Exceptions.create((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, code, msg, cause);
    }

    public static InvocationException genericProducer(String msg) {
        return Exceptions.producer("SCB.50000000", msg);
    }

    public static InvocationException genericProducer(String msg, Throwable cause) {
        return Exceptions.producer("SCB.50000000", msg, cause);
    }

    public static Response.StatusType getGenericStatus(@Nonnull Invocation invocation) {
        return InvocationType.CONSUMER.equals((Object)invocation.getInvocationType()) ? Response.Status.BAD_REQUEST : Response.Status.INTERNAL_SERVER_ERROR;
    }

    public static Response toConsumerResponse(Invocation invocation, Throwable throwable) {
        return processor.toConsumerResponse(invocation, throwable);
    }

    public static Response toProducerResponse(@Nullable Invocation invocation, Throwable exception) {
        return processor.toProducerResponse(invocation, exception);
    }

    public static InvocationException convert(@Nonnull Invocation invocation, Throwable throwable) {
        return processor.convert(invocation, throwable);
    }

    public static InvocationException convert(@Nullable Invocation invocation, Throwable throwable, Response.StatusType genericStatus) {
        return processor.convert(invocation, throwable, genericStatus);
    }

    public static boolean isPrintInvocationStackTrace() {
        return processor.isPrintStackTrace();
    }
}

