/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.codec.query.QueryCodecsUtils;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class QueryProcessorCreator
implements ParamValueProcessorCreator {
    public static final String PARAMTYPE = "query";

    public QueryProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        return new QueryProcessor((QueryParameter)parameter, targetType);
    }

    public static class QueryProcessor
    extends AbstractParamProcessor {
        private final boolean emptyAsNull = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.query.emptyAsNull", false).get();
        private final boolean ignoreDefaultValue = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.query.ignoreDefaultValue", false).get();
        private final boolean ignoreRequiredCheck = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.query.ignoreRequiredCheck", false).get();
        private final boolean repeatedType;
        private final QueryCodec queryCodec;

        public QueryProcessor(QueryParameter queryParameter, JavaType targetType) {
            super(queryParameter.getName(), targetType, queryParameter.getDefaultValue(), queryParameter.getRequired());
            this.repeatedType = ArrayProperty.isType((String)queryParameter.getType());
            this.queryCodec = QueryCodecsUtils.find(queryParameter.getCollectionFormat());
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            return this.queryCodec.decode(this, request);
        }

        public Object getAndCheckParameter(HttpServletRequest request) {
            String value = request.getParameter(this.paramPath);
            if (this.emptyAsNull && StringUtils.isEmpty((CharSequence)value)) {
                value = null;
            }
            return value != null ? value : this.checkRequiredAndDefaultValue();
        }

        private Object checkRequiredAndDefaultValue() {
            if (!this.ignoreRequiredCheck && this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            Object defaultValue = this.getDefaultValue();
            if (!this.ignoreDefaultValue && defaultValue != null) {
                return defaultValue;
            }
            return null;
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
        }

        @Override
        public String getProcessorType() {
            return QueryProcessorCreator.PARAMTYPE;
        }

        public QueryCodec getQueryCodec() {
            return this.queryCodec;
        }

        public boolean isRepeatedType() {
            return this.repeatedType;
        }

        public Object convertValue(Object value) {
            return this.convertValue(value, this.targetType);
        }
    }
}

