/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ELUtils;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends ELResolver {
    private AtomicReference<ELResolver[]> resolvers = new AtomicReference<ELResolver[]>(new ELResolver[0]);

    public synchronized void add(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        ELResolver[] rslvrs = this.resolvers.get();
        int sz = rslvrs.length;
        ELResolver[] nr = new ELResolver[sz + 1];
        System.arraycopy(rslvrs, 0, nr, 0, sz);
        nr[sz] = elResolver;
        this.resolvers.set(nr);
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        context.setPropertyResolved(false);
        ELResolver[] rslvrs = this.resolvers.get();
        int sz = rslvrs.length;
        Object result = null;
        for (int i = 0; i < sz; ++i) {
            result = rslvrs[i].getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        context.setPropertyResolved(false);
        ELResolver[] rslvrs = this.resolvers.get();
        int sz = rslvrs.length;
        for (int i = 0; i < sz; ++i) {
            rslvrs[i].setValue(context, base, property, value);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        context.setPropertyResolved(false);
        ELResolver[] rslvrs = this.resolvers.get();
        int sz = rslvrs.length;
        boolean readOnly = false;
        for (int i = 0; i < sz; ++i) {
            readOnly = rslvrs[i].isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return readOnly;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        ELResolver[] rslvrs = this.resolvers.get();
        int sz = rslvrs.length;
        return new FeatureIterator(context, base, rslvrs, sz);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        ELResolver[] rslvrs = this.resolvers.get();
        int sz = rslvrs.length;
        Class<?> commonType = null;
        Class<?> type = null;
        for (int i = 0; i < sz; ++i) {
            type = rslvrs[i].getCommonPropertyType(context, base);
            if (type == null || commonType != null && !commonType.isAssignableFrom(type)) continue;
            commonType = type;
        }
        return commonType;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        context.setPropertyResolved(false);
        ELResolver[] rslvrs = this.resolvers.get();
        int sz = rslvrs.length;
        for (int i = 0; i < sz; ++i) {
            Class<?> type = rslvrs[i].getType(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (context == null) {
            throw new NullPointerException("ELContext could not be null");
        }
        if (method == null || base == null) {
            return null;
        }
        String targetMethod = ELUtils.coerceToString(method);
        if (targetMethod.length() == 0) {
            throw new ELException(new NoSuchMethodException());
        }
        context.setPropertyResolved(false);
        ELResolver[] rslvrs = this.resolvers.get();
        int sz = rslvrs.length;
        Object retValue = null;
        for (int i = 0; i < sz; ++i) {
            retValue = rslvrs[i].invoke(context, base, targetMethod, paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return retValue;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FeatureIterator
    implements Iterator<FeatureDescriptor> {
        private final ELContext context;
        private final Object base;
        private final ELResolver[] resolvers;
        private final int size;
        private Iterator itr;
        private int idx;

        public FeatureIterator(ELContext context, Object base, ELResolver[] resolvers, int size) {
            this.context = context;
            this.base = base;
            this.resolvers = resolvers;
            this.size = size;
            this.idx = 0;
            this.guaranteeIterator();
        }

        private void guaranteeIterator() {
            while (this.itr == null && this.idx < this.size) {
                this.itr = this.resolvers[this.idx].getFeatureDescriptors(this.context, this.base);
                ++this.idx;
            }
        }

        @Override
        public boolean hasNext() {
            return this.itr != null;
        }

        @Override
        public FeatureDescriptor next() {
            Object result = null;
            if (this.itr != null && this.itr.hasNext()) {
                result = this.itr.next();
                if (!this.itr.hasNext()) {
                    this.itr = null;
                    this.guaranteeIterator();
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

