/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.ResourceBundleProvider;
import org.apache.openjpa.lib.util.SimpleResourceBundleProvider;
import org.apache.openjpa.lib.util.StreamResourceBundleProvider;
import org.apache.openjpa.lib.util.ZipResourceBundleProvider;

public class Localizer {
    private static final Map<String, Localizer> _localizers = new ConcurrentHashMap<String, Localizer>();
    private static final Collection<ResourceBundleProvider> _providers = new CopyOnWriteArraySet<ResourceBundleProvider>(Arrays.asList(new SimpleResourceBundleProvider(), new StreamResourceBundleProvider(), new ZipResourceBundleProvider()));
    private String _file;
    private String _pkg;
    private ResourceBundle _bundle = null;
    private Locale _locale;
    private ClassLoader _loader;

    public static Localizer forPackage(Class<?> cls) {
        return Localizer.forPackage(cls, null);
    }

    public static Localizer forPackage(Class<?> cls, Locale locale) {
        String file;
        String pkg;
        int dot;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        int n = dot = cls == null ? -1 : cls.getName().lastIndexOf(46);
        if (dot == -1) {
            pkg = "";
            file = "localizer";
        } else {
            pkg = cls.getName().substring(0, dot);
            file = pkg + ".localizer";
        }
        String key = file + locale.toString();
        Localizer loc = _localizers.get(key);
        if (loc != null) {
            return loc;
        }
        loc = new Localizer(pkg, file, locale, cls == null ? null : AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(cls)));
        _localizers.put(key, loc);
        return loc;
    }

    public static void addProvider(ResourceBundleProvider provider) {
        _providers.add(provider);
    }

    public static boolean removeProvider(ResourceBundleProvider provider) {
        return _providers.remove(provider);
    }

    private Localizer(String pkg, String f, Locale locale, ClassLoader loader) {
        this._pkg = pkg;
        this._file = f;
        this._locale = locale;
        this._loader = loader;
    }

    private ResourceBundle getBundle() {
        if (this._bundle == null) {
            Iterator<ResourceBundleProvider> itr = _providers.iterator();
            while (itr.hasNext() && this._bundle == null) {
                this._bundle = itr.next().findResource(this._file, this._locale, this._loader);
            }
        }
        return this._bundle;
    }

    public Message get(String key) {
        return this.get(key, null);
    }

    public Message getFatal(String key) {
        return this.getFatal(key, null);
    }

    public Message get(String key, Object sub) {
        return this.get(key, new Object[]{sub});
    }

    public Message getFatal(String key, Object sub) {
        return this.getFatal(key, new Object[]{sub});
    }

    public Message get(String key, Object sub1, Object sub2) {
        return this.get(key, new Object[]{sub1, sub2});
    }

    public Message getFatal(String key, Object sub1, Object sub2) {
        return this.getFatal(key, new Object[]{sub1, sub2});
    }

    public Message get(String key, Object sub1, Object sub2, Object sub3) {
        return this.get(key, new Object[]{sub1, sub2, sub3});
    }

    public Message get(String key, Object[] subs) {
        return new Message(this._pkg, this.getBundle(), key, subs, false);
    }

    public Message getFatal(String key, Object[] subs) {
        return new Message(this._pkg, this.getBundle(), key, subs, true);
    }

    public static class Message {
        private final String _pkg;
        private final String _key;
        private final Object[] _subs;
        private final String _localizedMessage;
        private boolean _localizedMessageFound;

        private Message(String packageName, ResourceBundle bundle, String key, Object[] subs, boolean fatal) {
            if (bundle == null && fatal) {
                throw new MissingResourceException(key, key, key);
            }
            this._pkg = packageName;
            this._key = key;
            this._subs = subs;
            if (bundle == null) {
                this._localizedMessage = key;
                this._localizedMessageFound = false;
            } else {
                String localized = null;
                try {
                    localized = bundle.getString(key);
                    this._localizedMessageFound = true;
                }
                catch (MissingResourceException mre) {
                    if (fatal) {
                        throw mre;
                    }
                    this._localizedMessageFound = false;
                }
                this._localizedMessage = localized == null ? key : localized;
            }
        }

        public String getMessage() {
            if (this._localizedMessageFound) {
                return MessageFormat.format(this._localizedMessage, this._subs);
            }
            if (this._subs == null || this._subs.length == 0) {
                return "localized message key: " + this._localizedMessage;
            }
            return "localized message key: " + this._localizedMessage + "; substitutions: " + Arrays.asList(this._subs).toString();
        }

        public String getKey() {
            return this._key;
        }

        public Object[] getSubstitutions() {
            return this._subs;
        }

        public String getPackageName() {
            return this._pkg;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

