/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.mail.internet.AddressException;
import java.time.Instant;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.webadmin.vault.routes.DeletedMessagesVaultExportTask;

public class DeletedMessagesVaultExportTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final String userExportFrom;
    private final String exportTo;
    private final Long totalExportedMessages;
    private final Instant timestamp;

    private static DeletedMessagesVaultExportTaskAdditionalInformationDTO fromDomainObject(DeletedMessagesVaultExportTask.AdditionalInformation additionalInformation, String type) {
        return new DeletedMessagesVaultExportTaskAdditionalInformationDTO(type, additionalInformation.getUserExportFrom(), additionalInformation.getExportTo(), additionalInformation.getTotalExportedMessages(), additionalInformation.timestamp());
    }

    public static final AdditionalInformationDTOModule<DeletedMessagesVaultExportTask.AdditionalInformation, DeletedMessagesVaultExportTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(DeletedMessagesVaultExportTask.AdditionalInformation.class).convertToDTO(DeletedMessagesVaultExportTaskAdditionalInformationDTO.class).toDomainObjectConverter(DeletedMessagesVaultExportTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(DeletedMessagesVaultExportTaskAdditionalInformationDTO::fromDomainObject).typeName(DeletedMessagesVaultExportTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public DeletedMessagesVaultExportTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="user") String userExportFrom, @JsonProperty(value="exportTo") String exportTo, @JsonProperty(value="errorRestoreCount") Long totalExportedMessages, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.userExportFrom = userExportFrom;
        this.exportTo = exportTo;
        this.totalExportedMessages = totalExportedMessages;
        this.timestamp = timestamp;
    }

    public String getUserExportFrom() {
        return this.userExportFrom;
    }

    public String getExportTo() {
        return this.exportTo;
    }

    public Long getTotalExportedMessages() {
        return this.totalExportedMessages;
    }

    DeletedMessagesVaultExportTask.AdditionalInformation toDomainObject() {
        try {
            return new DeletedMessagesVaultExportTask.AdditionalInformation(Username.of((String)this.userExportFrom), new MailAddress(this.exportTo), this.totalExportedMessages, this.timestamp);
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }
}

