/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.dto.EventDTO;
import org.apache.james.eventsourcing.eventstore.dto.EventDTOModule;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.filtering.FilteringRuleSetDefineDTOModules;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.api.upload.UploadUsageRepository;
import org.apache.james.jmap.postgres.PostgresDataJMapAggregateDataDefinition;
import org.apache.james.jmap.postgres.change.PostgresEmailChangeRepository;
import org.apache.james.jmap.postgres.change.PostgresMailboxChangeRepository;
import org.apache.james.jmap.postgres.change.PostgresStateFactory;
import org.apache.james.jmap.postgres.pushsubscription.PostgresPushSubscriptionRepository;
import org.apache.james.jmap.postgres.upload.PostgresUploadUsageRepository;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.store.StoreAttachmentManager;
import org.apache.james.mailbox.store.StoreMessageIdManager;
import org.apache.james.mailbox.store.StoreRightManager;

public class PostgresJmapModule
extends AbstractModule {
    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), PostgresDataDefinition.class).addBinding().toInstance((Object)PostgresDataJMapAggregateDataDefinition.MODULE);
        this.bind(EmailChangeRepository.class).to(PostgresEmailChangeRepository.class);
        this.bind(PostgresEmailChangeRepository.class).in(Scopes.SINGLETON);
        this.bind(MailboxChangeRepository.class).to(PostgresMailboxChangeRepository.class);
        this.bind(PostgresMailboxChangeRepository.class).in(Scopes.SINGLETON);
        this.bind(Limit.class).annotatedWith((Annotation)Names.named((String)"emailChangeDefaultLimit")).toInstance((Object)Limit.of((int)256));
        this.bind(Limit.class).annotatedWith((Annotation)Names.named((String)"mailboxChangeDefaultLimit")).toInstance((Object)Limit.of((int)256));
        this.bind(UploadUsageRepository.class).to(PostgresUploadUsageRepository.class);
        this.bind(MessageIdManager.class).to(StoreMessageIdManager.class);
        this.bind(AttachmentManager.class).to(StoreAttachmentManager.class);
        this.bind(StoreMessageIdManager.class).in(Scopes.SINGLETON);
        this.bind(StoreAttachmentManager.class).in(Scopes.SINGLETON);
        this.bind(RightManager.class).to(StoreRightManager.class);
        this.bind(StoreRightManager.class).in(Scopes.SINGLETON);
        this.bind(State.Factory.class).to(PostgresStateFactory.class);
        this.bind(PushSubscriptionRepository.class).to(PostgresPushSubscriptionRepository.class);
        Multibinder eventDTOModuleBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<EventDTOModule<? extends Event, ? extends EventDTO>>(this){});
        eventDTOModuleBinder.addBinding().toInstance((Object)FilteringRuleSetDefineDTOModules.FILTERING_RULE_SET_DEFINED);
        eventDTOModuleBinder.addBinding().toInstance((Object)FilteringRuleSetDefineDTOModules.FILTERING_INCREMENT);
    }
}

