/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.AuthenticationMessage;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class AuthenticationGSSContinue
implements AuthenticationMessage {
    private final ByteBuffer authenticationData;

    public AuthenticationGSSContinue(ByteBuf authenticationData) {
        Assert.requireNonNull(authenticationData, "authenticationData must not be null");
        this.authenticationData = ByteBufferUtils.toByteBuffer(authenticationData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationGSSContinue that = (AuthenticationGSSContinue)o;
        return Objects.equals(this.authenticationData, that.authenticationData);
    }

    public ByteBuffer getAuthenticationData() {
        return this.authenticationData;
    }

    public int hashCode() {
        return Objects.hash(this.authenticationData);
    }

    public String toString() {
        return "AuthenticationGSSContinue{authenticationData=" + this.authenticationData + '}';
    }

    static AuthenticationGSSContinue decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        return new AuthenticationGSSContinue(in.readSlice(in.readableBytes()));
    }
}

