/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.IDeviceSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableAttributeSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceLastCache;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceNormalSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceTemplateSchema;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.schema.IMeasurementSchema;

@ThreadSafe
public class TableDeviceCacheEntry {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableDeviceCacheEntry.class) + 2L * RamUsageEstimator.shallowSizeOfInstance(AtomicReference.class);
    private final AtomicReference<IDeviceSchema> deviceSchema = new AtomicReference();
    private final AtomicReference<TableDeviceLastCache> lastCache = new AtomicReference();

    int setAttribute(String database, String tableName, @Nonnull Map<String, Binary> attributeSetMap) {
        return (this.deviceSchema.compareAndSet(null, new TableAttributeSchema()) ? TableAttributeSchema.INSTANCE_SIZE : 0) + this.updateAttribute(database, tableName, attributeSetMap);
    }

    int updateAttribute(String database, String tableName, @Nonnull Map<String, Binary> updateMap) {
        TableAttributeSchema schema = (TableAttributeSchema)this.deviceSchema.get();
        int result = Objects.nonNull(schema) ? schema.updateAttribute(database, tableName, updateMap) : 0;
        return Objects.nonNull(this.deviceSchema.get()) ? result : 0;
    }

    int invalidateAttribute() {
        AtomicInteger size = new AtomicInteger(0);
        this.deviceSchema.updateAndGet(schema -> {
            if (schema instanceof TableAttributeSchema) {
                size.set(schema.estimateSize());
                return null;
            }
            return schema;
        });
        return size.get();
    }

    int invalidateAttributeColumn(String attribute) {
        AtomicInteger size = new AtomicInteger(0);
        this.deviceSchema.updateAndGet(schema -> {
            if (schema instanceof TableAttributeSchema) {
                size.set(((TableAttributeSchema)schema).removeAttribute(attribute));
                return schema;
            }
            return schema;
        });
        return size.get();
    }

    Map<String, Binary> getAttributeMap() {
        IDeviceSchema map = this.deviceSchema.get();
        if (Objects.isNull(map)) {
            return null;
        }
        return map instanceof TableAttributeSchema ? ((TableAttributeSchema)map).getAttributeMap() : Collections.emptyMap();
    }

    int setDeviceSchema(String database, DeviceSchemaInfo deviceSchemaInfo) {
        if (deviceSchemaInfo.getTemplateId() == -1) {
            int result = this.deviceSchema.compareAndSet(null, new TreeDeviceNormalSchema(database, deviceSchemaInfo.isAligned())) ? TreeDeviceNormalSchema.INSTANCE_SIZE : 0;
            return this.deviceSchema.get() instanceof TreeDeviceNormalSchema ? result + ((TreeDeviceNormalSchema)this.deviceSchema.get()).update(deviceSchemaInfo.getMeasurementSchemaInfoList()) : 0;
        }
        return this.deviceSchema.compareAndSet(null, new TreeDeviceTemplateSchema(database, deviceSchemaInfo.getTemplateId())) ? TreeDeviceTemplateSchema.INSTANCE_SIZE : 0;
    }

    int setMeasurementSchema(String database, boolean isAligned, String[] measurements, IMeasurementSchema[] schemas) {
        if (schemas == null) {
            return 0;
        }
        int result = this.deviceSchema.compareAndSet(null, new TreeDeviceNormalSchema(database, isAligned)) ? TreeDeviceNormalSchema.INSTANCE_SIZE : 0;
        return this.deviceSchema.get() instanceof TreeDeviceNormalSchema ? result + ((TreeDeviceNormalSchema)this.deviceSchema.get()).update(measurements, schemas) : 0;
    }

    IDeviceSchema getDeviceSchema() {
        return this.deviceSchema.get();
    }

    int invalidateTreeSchema() {
        AtomicInteger size = new AtomicInteger(0);
        this.deviceSchema.updateAndGet(schema -> {
            if (schema instanceof TreeDeviceNormalSchema || schema instanceof TreeDeviceTemplateSchema) {
                size.set(schema.estimateSize());
                return null;
            }
            return schema;
        });
        return size.get();
    }

    int initOrInvalidateLastCache(String database, String tableName, String[] measurements, boolean isInvalidate, boolean isTableModel) {
        int result = this.lastCache.compareAndSet(null, new TableDeviceLastCache()) ? TableDeviceLastCache.INSTANCE_SIZE : 0;
        TableDeviceLastCache cache = this.lastCache.get();
        return Objects.nonNull(this.lastCache.get()) ? (result += Objects.nonNull(cache) ? cache.initOrInvalidate(database, tableName, measurements, isInvalidate, isTableModel) : 0) : 0;
    }

    int tryUpdateLastCache(String[] measurements, TimeValuePair[] timeValuePairs, boolean invalidateNull) {
        TableDeviceLastCache cache = this.lastCache.get();
        int result = Objects.nonNull(cache) ? cache.tryUpdate(measurements, timeValuePairs, invalidateNull) : 0;
        return Objects.nonNull(this.lastCache.get()) ? result : 0;
    }

    int tryUpdateLastCache(String[] measurements, TimeValuePair[] timeValuePairs) {
        return this.tryUpdateLastCache(measurements, timeValuePairs, false);
    }

    int invalidateLastCache(String measurement, boolean isTableModel) {
        TableDeviceLastCache cache = this.lastCache.get();
        int result = Objects.nonNull(cache) ? cache.invalidate(measurement, isTableModel) : 0;
        return Objects.nonNull(this.lastCache.get()) ? result : 0;
    }

    TimeValuePair getTimeValuePair(String measurement) {
        TableDeviceLastCache cache = this.lastCache.get();
        return Objects.nonNull(cache) ? cache.getTimeValuePair(measurement) : null;
    }

    boolean updateInputMap(@Nonnull Map<String, Pair<TSDataType, TimeValuePair>> updateMap) {
        for (String measurement : updateMap.keySet()) {
            TimeValuePair result = this.getTimeValuePair(measurement);
            if (result == null) {
                return false;
            }
            updateMap.get(measurement).setRight((Object)result);
        }
        return true;
    }

    Optional<Pair<OptionalLong, TsPrimitiveType[]>> getLastRow(String sourceMeasurement, List<String> targetMeasurements) {
        TableDeviceLastCache cache = this.lastCache.get();
        return Objects.nonNull(cache) ? cache.getLastRow(sourceMeasurement, targetMeasurements) : Optional.empty();
    }

    int invalidateLastCache() {
        AtomicInteger size = new AtomicInteger(0);
        this.lastCache.updateAndGet(cacheEntry -> {
            if (Objects.nonNull(cacheEntry)) {
                size.set(cacheEntry.estimateSize());
            }
            return null;
        });
        return size.get();
    }

    int estimateSize() {
        IDeviceSchema schema = this.deviceSchema.get();
        TableDeviceLastCache cache = this.lastCache.get();
        return (int)(INSTANCE_SIZE + (long)(Objects.nonNull(schema) ? schema.estimateSize() : 0) + (long)(Objects.nonNull(cache) ? cache.estimateSize() : 0));
    }
}

