/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

public class RaftClientRequest
extends RaftClientMessage {
    private static final Type DATA_STREAM_DEFAULT = new Type(RaftProtos.DataStreamRequestTypeProto.getDefaultInstance());
    private static final Type FORWARD_DEFAULT = new Type(RaftProtos.ForwardRequestTypeProto.getDefaultInstance());
    private static final Type WATCH_DEFAULT = new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(0L).setReplication(RaftProtos.ReplicationLevel.MAJORITY).build());
    private static final Type READ_AFTER_WRITE_CONSISTENT_DEFAULT = new Type(RaftProtos.ReadRequestTypeProto.newBuilder().setReadAfterWriteConsistent(true).build());
    private static final Type READ_DEFAULT = new Type(RaftProtos.ReadRequestTypeProto.getDefaultInstance());
    private static final Type READ_NONLINEARIZABLE_DEFAULT = new Type(RaftProtos.ReadRequestTypeProto.newBuilder().setPreferNonLinearizable(true).build());
    private static final Type STALE_READ_DEFAULT = new Type(RaftProtos.StaleReadRequestTypeProto.getDefaultInstance());
    private static final Map<RaftProtos.ReplicationLevel, Type> WRITE_REQUEST_TYPES;
    private final Message message;
    private final Type type;
    private final Iterable<Long> repliedCallIds;
    private final RaftProtos.SlidingWindowEntry slidingWindowEntry;
    private final RoutingTable routingTable;
    private final long timeoutMs;
    private final boolean toLeader;

    public static Type writeRequestType(RaftProtos.ReplicationLevel replication) {
        return WRITE_REQUEST_TYPES.get(replication);
    }

    public static Type writeRequestType() {
        return RaftClientRequest.writeRequestType(RaftProtos.ReplicationLevel.MAJORITY);
    }

    public static Type dataStreamRequestType() {
        return DATA_STREAM_DEFAULT;
    }

    public static Type forwardRequestType() {
        return FORWARD_DEFAULT;
    }

    public static Type messageStreamRequestType(long streamId, long messageId, boolean endOfRequest) {
        return new Type(RaftProtos.MessageStreamRequestTypeProto.newBuilder().setStreamId(streamId).setMessageId(messageId).setEndOfRequest(endOfRequest).build());
    }

    public static Type readAfterWriteConsistentRequestType() {
        return READ_AFTER_WRITE_CONSISTENT_DEFAULT;
    }

    public static Type readRequestType() {
        return READ_DEFAULT;
    }

    public static Type readRequestType(boolean nonLinearizable) {
        return nonLinearizable ? READ_NONLINEARIZABLE_DEFAULT : RaftClientRequest.readRequestType();
    }

    public static Type staleReadRequestType(long minIndex) {
        return minIndex == 0L ? STALE_READ_DEFAULT : new Type(RaftProtos.StaleReadRequestTypeProto.newBuilder().setMinIndex(minIndex).build());
    }

    public static Type watchRequestType() {
        return WATCH_DEFAULT;
    }

    public static Type watchRequestType(long index, RaftProtos.ReplicationLevel replication) {
        return new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(index).setReplication(replication).build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static RaftClientRequest toWriteRequest(RaftClientRequest r, Message message) {
        return RaftClientRequest.newBuilder().setClientId(r.getClientId()).setServerId(r.getServerId()).setGroupId(r.getRaftGroupId()).setCallId(r.getCallId()).setMessage(message).setType(RaftClientRequest.writeRequestType()).setSlidingWindowEntry(r.getSlidingWindowEntry()).build();
    }

    protected RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Type type) {
        this(RaftClientRequest.newBuilder().setClientId(clientId).setServerId(serverId).setGroupId(groupId).setCallId(callId).setType(type));
    }

    protected RaftClientRequest(ClientId clientId, RaftPeerId leaderId, RaftGroupId groupId, long callId, Type type, long timeoutMs) {
        this(RaftClientRequest.newBuilder().setClientId(clientId).setLeaderId(leaderId).setGroupId(groupId).setCallId(callId).setType(type).setTimeoutMs(timeoutMs));
    }

    private RaftClientRequest(Builder b) {
        super(b.clientId, b.serverId, b.groupId, b.callId);
        this.toLeader = b.toLeader;
        this.message = b.message;
        this.type = b.type;
        this.repliedCallIds = Optional.ofNullable(b.repliedCallIds).orElseGet(Collections::emptyList);
        this.slidingWindowEntry = b.slidingWindowEntry;
        this.routingTable = b.routingTable;
        this.timeoutMs = b.timeoutMs;
    }

    @Override
    public final boolean isRequest() {
        return true;
    }

    public boolean isToLeader() {
        return this.toLeader;
    }

    public Iterable<Long> getRepliedCallIds() {
        return this.repliedCallIds;
    }

    public RaftProtos.SlidingWindowEntry getSlidingWindowEntry() {
        return this.slidingWindowEntry;
    }

    public Message getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public boolean is(RaftProtos.RaftClientRequestProto.TypeCase typeCase) {
        return this.getType().is(typeCase);
    }

    public boolean isReadOnly() {
        return this.getType().isReadOnly();
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public String toString() {
        return super.toString() + ", seq=" + ProtoUtils.toString(this.slidingWindowEntry) + ", " + this.type + ", " + this.getMessage();
    }

    static {
        EnumMap<RaftProtos.ReplicationLevel, Type> map = new EnumMap<RaftProtos.ReplicationLevel, Type>(RaftProtos.ReplicationLevel.class);
        for (RaftProtos.ReplicationLevel replication : RaftProtos.ReplicationLevel.values()) {
            if (replication == RaftProtos.ReplicationLevel.UNRECOGNIZED) continue;
            RaftProtos.WriteRequestTypeProto write = RaftProtos.WriteRequestTypeProto.newBuilder().setReplication(replication).build();
            map.put(replication, new Type(write));
        }
        WRITE_REQUEST_TYPES = Collections.unmodifiableMap(map);
    }

    public static class Builder {
        private ClientId clientId;
        private RaftPeerId serverId;
        private RaftGroupId groupId;
        private long callId;
        private boolean toLeader;
        private Iterable<Long> repliedCallIds = Collections.emptyList();
        private Message message;
        private Type type;
        private RaftProtos.SlidingWindowEntry slidingWindowEntry;
        private RoutingTable routingTable;
        private long timeoutMs;

        public RaftClientRequest build() {
            return new RaftClientRequest(this);
        }

        public Builder setClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setLeaderId(RaftPeerId leaderId) {
            this.serverId = leaderId;
            this.toLeader = true;
            return this;
        }

        public Builder setServerId(RaftPeerId serverId) {
            this.serverId = serverId;
            this.toLeader = false;
            return this;
        }

        public Builder setGroupId(RaftGroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder setCallId(long callId) {
            this.callId = callId;
            return this;
        }

        public Builder setRepliedCallIds(Iterable<Long> repliedCallIds) {
            this.repliedCallIds = repliedCallIds;
            return this;
        }

        public Builder setMessage(Message message) {
            this.message = message;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setSlidingWindowEntry(RaftProtos.SlidingWindowEntry slidingWindowEntry) {
            this.slidingWindowEntry = slidingWindowEntry;
            return this;
        }

        public Builder setRoutingTable(RoutingTable routingTable) {
            this.routingTable = routingTable;
            return this;
        }

        public Builder setTimeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }
    }

    public static final class Type {
        private final RaftProtos.RaftClientRequestProto.TypeCase typeCase;
        private final Object proto;

        public static Type valueOf(RaftProtos.WriteRequestTypeProto write) {
            return RaftClientRequest.writeRequestType(write.getReplication());
        }

        public static Type valueOf(RaftProtos.DataStreamRequestTypeProto dataStream) {
            return DATA_STREAM_DEFAULT;
        }

        public static Type valueOf(RaftProtos.ForwardRequestTypeProto forward) {
            return FORWARD_DEFAULT;
        }

        public static Type valueOf(RaftProtos.ReadRequestTypeProto read) {
            return read.getPreferNonLinearizable() ? READ_NONLINEARIZABLE_DEFAULT : (read.getReadAfterWriteConsistent() ? READ_AFTER_WRITE_CONSISTENT_DEFAULT : READ_DEFAULT);
        }

        public static Type valueOf(RaftProtos.StaleReadRequestTypeProto staleRead) {
            return staleRead.getMinIndex() == 0L ? STALE_READ_DEFAULT : new Type(staleRead);
        }

        public static Type valueOf(RaftProtos.WatchRequestTypeProto watch) {
            return RaftClientRequest.watchRequestType(watch.getIndex(), watch.getReplication());
        }

        public static Type valueOf(RaftProtos.MessageStreamRequestTypeProto messageStream) {
            return RaftClientRequest.messageStreamRequestType(messageStream.getStreamId(), messageStream.getMessageId(), messageStream.getEndOfRequest());
        }

        private Type(RaftProtos.RaftClientRequestProto.TypeCase typeCase, Object proto) {
            this.typeCase = Objects.requireNonNull(typeCase, "typeCase == null");
            this.proto = Objects.requireNonNull(proto, "proto == null");
        }

        private Type(RaftProtos.WriteRequestTypeProto write) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, write);
        }

        private Type(RaftProtos.DataStreamRequestTypeProto dataStream) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.DATASTREAM, dataStream);
        }

        private Type(RaftProtos.ForwardRequestTypeProto forward) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.FORWARD, forward);
        }

        private Type(RaftProtos.MessageStreamRequestTypeProto messageStream) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM, messageStream);
        }

        private Type(RaftProtos.ReadRequestTypeProto read) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.READ, read);
        }

        private Type(RaftProtos.StaleReadRequestTypeProto staleRead) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD, staleRead);
        }

        private Type(RaftProtos.WatchRequestTypeProto watch) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, watch);
        }

        public boolean is(RaftProtos.RaftClientRequestProto.TypeCase t) {
            return this.getTypeCase() == t;
        }

        public boolean isReadOnly() {
            switch (this.getTypeCase()) {
                case READ: 
                case STALEREAD: 
                case WATCH: {
                    return true;
                }
                case WRITE: 
                case MESSAGESTREAM: 
                case DATASTREAM: 
                case FORWARD: {
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected type case: " + this.getTypeCase());
        }

        public RaftProtos.RaftClientRequestProto.TypeCase getTypeCase() {
            return this.typeCase;
        }

        private void assertType(RaftProtos.RaftClientRequestProto.TypeCase expected) {
            Preconditions.assertSame(expected, this.getTypeCase(), "type");
        }

        public RaftProtos.WriteRequestTypeProto getWrite() {
            this.assertType(RaftProtos.RaftClientRequestProto.TypeCase.WRITE);
            return (RaftProtos.WriteRequestTypeProto)this.proto;
        }

        public RaftProtos.DataStreamRequestTypeProto getDataStream() {
            this.assertType(RaftProtos.RaftClientRequestProto.TypeCase.DATASTREAM);
            return (RaftProtos.DataStreamRequestTypeProto)this.proto;
        }

        public RaftProtos.ForwardRequestTypeProto getForward() {
            this.assertType(RaftProtos.RaftClientRequestProto.TypeCase.FORWARD);
            return (RaftProtos.ForwardRequestTypeProto)this.proto;
        }

        public RaftProtos.MessageStreamRequestTypeProto getMessageStream() {
            this.assertType(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM);
            return (RaftProtos.MessageStreamRequestTypeProto)this.proto;
        }

        public RaftProtos.ReadRequestTypeProto getRead() {
            this.assertType(RaftProtos.RaftClientRequestProto.TypeCase.READ);
            return (RaftProtos.ReadRequestTypeProto)this.proto;
        }

        public RaftProtos.StaleReadRequestTypeProto getStaleRead() {
            this.assertType(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD);
            return (RaftProtos.StaleReadRequestTypeProto)this.proto;
        }

        public RaftProtos.WatchRequestTypeProto getWatch() {
            this.assertType(RaftProtos.RaftClientRequestProto.TypeCase.WATCH);
            return (RaftProtos.WatchRequestTypeProto)this.proto;
        }

        public static String toString(RaftProtos.ReplicationLevel replication) {
            return replication == RaftProtos.ReplicationLevel.MAJORITY ? "" : "-" + replication;
        }

        public static String toString(RaftProtos.WatchRequestTypeProto w) {
            return "Watch" + Type.toString(w.getReplication()) + "(" + w.getIndex() + ")";
        }

        public static String toString(RaftProtos.MessageStreamRequestTypeProto s) {
            return "MessageStream" + s.getStreamId() + "-" + s.getMessageId() + (s.getEndOfRequest() ? "-eor" : "");
        }

        public String toString() {
            switch (this.typeCase) {
                case WRITE: {
                    return "RW";
                }
                case DATASTREAM: {
                    return "DataStream";
                }
                case FORWARD: {
                    return "Forward";
                }
                case MESSAGESTREAM: {
                    return Type.toString(this.getMessageStream());
                }
                case READ: {
                    RaftProtos.ReadRequestTypeProto read = this.getRead();
                    return read.getReadAfterWriteConsistent() ? "RaW" : (read.getPreferNonLinearizable() ? "RO(pNL)" : "RO");
                }
                case STALEREAD: {
                    return "StaleRead(" + this.getStaleRead().getMinIndex() + ")";
                }
                case WATCH: {
                    return Type.toString(this.getWatch());
                }
            }
            throw new IllegalStateException("Unexpected request type: " + this.typeCase);
        }
    }
}

