/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.plugin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.DataNodePipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginClassLoader;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginClassLoaderManager;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginExecutableManager;
import org.apache.iotdb.db.pipe.agent.plugin.dataregion.PipeDataRegionPluginAgent;
import org.apache.iotdb.db.pipe.agent.plugin.schemaregion.PipeSchemaRegionPluginAgent;
import org.apache.iotdb.pipe.api.PipePlugin;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodePluginAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodePluginAgent.class);
    private final DataNodePipePluginMetaKeeper pipePluginMetaKeeper = new DataNodePipePluginMetaKeeper();
    private final PipeDataRegionPluginAgent dataRegionAgent = new PipeDataRegionPluginAgent(this.pipePluginMetaKeeper);
    private final PipeSchemaRegionPluginAgent schemaRegionAgent = new PipeSchemaRegionPluginAgent(null);
    private final ReentrantLock lock = new ReentrantLock();

    public PipeDataRegionPluginAgent dataRegion() {
        return this.dataRegionAgent;
    }

    public PipeSchemaRegionPluginAgent schemaRegion() {
        return this.schemaRegionAgent;
    }

    public void register(PipePluginMeta pipePluginMeta, ByteBuffer jarFile) throws IOException, PipeException {
        this.lock.lock();
        try {
            this.deregister(pipePluginMeta.getPluginName(), false);
            this.checkIfRegistered(pipePluginMeta);
            this.saveJarFileIfNeeded(pipePluginMeta.getPluginName(), pipePluginMeta.getJarName(), jarFile);
            this.doRegister(pipePluginMeta);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkIfRegistered(PipePluginMeta pipePluginMeta) throws PipeException {
        String pluginName = pipePluginMeta.getPluginName();
        PipePluginMeta information = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName);
        if (information == null) {
            return;
        }
        if (information.isBuiltin()) {
            String errorMessage = String.format("Failed to register PipePlugin %s, because the given PipePlugin name is the same as a built-in PipePlugin name.", pluginName);
            LOGGER.warn(errorMessage);
            throw new PipeException(errorMessage);
        }
        if (PipePluginExecutableManager.getInstance().hasPluginFileUnderInstallDir(pipePluginMeta.getPluginName(), pipePluginMeta.getJarName()) && !PipePluginExecutableManager.getInstance().isLocalJarMatched(pipePluginMeta)) {
            String errMsg = String.format("Failed to register PipePlugin %s, because existed md5 of jar file for pipe plugin %s is different from the new jar file.", pluginName, pluginName);
            LOGGER.warn(errMsg);
            throw new PipeException(errMsg);
        }
    }

    private void saveJarFileIfNeeded(String pluginName, String jarName, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer != null) {
            PipePluginExecutableManager.getInstance().savePluginToInstallDir(byteBuffer, pluginName, jarName);
        }
    }

    public void doRegister(PipePluginMeta pipePluginMeta) throws PipeException {
        String pluginName = pipePluginMeta.getPluginName();
        String className = pipePluginMeta.getClassName();
        try {
            PipePluginClassLoaderManager classLoaderManager = PipePluginClassLoaderManager.getInstance();
            String pluginDirPath = PipePluginExecutableManager.getInstance().getPluginsDirPath(pluginName);
            PipePluginClassLoader pipePluginClassLoader = classLoaderManager.createPipePluginClassLoader(pluginDirPath);
            Class<?> pluginClass = Class.forName(className, true, (ClassLoader)pipePluginClassLoader);
            PipePlugin ignored = (PipePlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.pipePluginMetaKeeper.addPipePluginMeta(pluginName, pipePluginMeta);
            classLoaderManager.addPluginAndClassLoader(pluginName, pipePluginClassLoader);
        }
        catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to register PipePlugin %s(%s), because its instance can not be constructed successfully. Exception: %s", pluginName.toUpperCase(), className, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new PipeException(errorMessage);
        }
    }

    public void deregister(String pluginName, boolean needToDeleteJar) throws PipeException {
        this.lock.lock();
        try {
            PipePluginMeta information = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName);
            if (information != null && information.isBuiltin()) {
                String errorMessage = String.format("Failed to deregister builtin PipePlugin %s.", pluginName);
                LOGGER.warn(errorMessage);
                throw new PipeException(errorMessage);
            }
            this.pipePluginMetaKeeper.removePipePluginMeta(pluginName);
            PipePluginClassLoaderManager.getInstance().removePluginClassLoader(pluginName);
            if (information != null && needToDeleteJar) {
                PipePluginExecutableManager.getInstance().removePluginFileUnderLibRoot(information.getPluginName(), information.getJarName());
                PipePluginExecutableManager.getInstance().removeFileUnderTemporaryRoot(pluginName.toUpperCase() + ".txt");
            }
        }
        catch (IOException e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void validate(String pipeName, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) throws Exception {
        this.dataRegionAgent.validate(pipeName, extractorAttributes, processorAttributes, connectorAttributes);
        this.schemaRegionAgent.validate(pipeName, extractorAttributes, processorAttributes, connectorAttributes);
    }

    public void validateExtractor(Map<String, String> extractorAttributes) throws Exception {
        this.dataRegionAgent.validateExtractor(extractorAttributes);
        this.schemaRegionAgent.validateExtractor(extractorAttributes);
    }

    public void validateProcessor(Map<String, String> processorAttributes) throws Exception {
        this.dataRegionAgent.validateProcessor(processorAttributes);
        this.schemaRegionAgent.validateProcessor(processorAttributes);
    }

    public void validateConnector(String pipeName, Map<String, String> connectorAttributes) throws Exception {
        this.dataRegionAgent.validateConnector(pipeName, connectorAttributes);
        this.schemaRegionAgent.validateConnector(pipeName, connectorAttributes);
    }
}

