/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class DataAuthPlan
extends PhysicalPlan {
    private List<String> users;

    public DataAuthPlan(Operator.OperatorType operatorType) {
        super(operatorType);
    }

    public DataAuthPlan(Operator.OperatorType operatorType, List<String> users) {
        super(operatorType);
        this.users = users;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = this.getPlanType(super.getOperatorType());
        stream.writeByte((byte)type);
        stream.writeInt(this.users.size());
        for (String user : this.users) {
            this.putString(stream, user);
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = this.getPlanType(super.getOperatorType());
        buffer.put((byte)type);
        buffer.putInt(this.users.size());
        for (String user : this.users) {
            this.putString(buffer, user);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int userSize = buffer.getInt();
        this.users = new ArrayList<String>(userSize);
        for (int i = 0; i < userSize; ++i) {
            this.users.add(this.readString(buffer));
        }
    }

    private int getPlanType(Operator.OperatorType operatorType) {
        int type;
        if (operatorType == Operator.OperatorType.GRANT_WATERMARK_EMBEDDING) {
            type = PhysicalPlan.PhysicalPlanType.GRANT_WATERMARK_EMBEDDING.ordinal();
        } else if (operatorType == Operator.OperatorType.REVOKE_WATERMARK_EMBEDDING) {
            type = PhysicalPlan.PhysicalPlanType.REVOKE_WATERMARK_EMBEDDING.ordinal();
        } else {
            throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)operatorType));
        }
        return type;
    }
}

