/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.counter;

import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.CounterTraverser;
import org.apache.iotdb.db.metadata.path.PartialPath;

public class MNodeLevelCounter
extends CounterTraverser {
    protected int targetLevel;
    private Set<IMNode> processedNodes = new HashSet<IMNode>();

    public MNodeLevelCounter(IMNode startNode, PartialPath path, int targetLevel) throws MetadataException {
        super(startNode, path);
        this.targetLevel = targetLevel;
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
        if (level < this.targetLevel) {
            return false;
        }
        while (level > this.targetLevel) {
            node = node.getParent();
            --level;
        }
        if (!this.processedNodes.contains(node)) {
            this.processedNodes.add(node);
            ++this.count;
        }
        return true;
    }
}

