/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.util.regex.Pattern;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.exception.UDFException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDTFMatches
implements UDTF {
    private Pattern pattern;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateRequiredAttribute("regex").validateInputSeriesDataType(0, TSDataType.TEXT);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.pattern = Pattern.compile(parameters.getString("regex"));
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(TSDataType.BOOLEAN);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putBoolean(row.getTime(), this.pattern.matcher(row.getString(0)).matches());
    }
}

