/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.rocksdb.RocksUtils;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite3.internal.storage.rocksdb.ThreadLocalState;
import org.apache.ignite3.internal.storage.util.LockByRowId;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractNativeReference;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatchWithIndex;

public final class PartitionDataHelper
implements ManuallyCloseable {
    private static final int TX_ID_SIZE = 16;
    static final int ROW_ID_OFFSET = 6;
    public static final int ROW_PREFIX_SIZE = 22;
    static final int MAX_KEY_SIZE = 30;
    static final int DATA_ID_SIZE = 24;
    private static final int DATA_ID_OFFSET = 6;
    private static final int PAYLOAD_KEY_SIZE = 30;
    private static final int TX_STATE_SIZE = 22;
    static final int DATA_ID_WITH_TX_STATE_SIZE = 46;
    static final ThreadLocal<ThreadLocalState> THREAD_LOCAL_STATE = new ThreadLocal();
    private static final ThreadLocal<ByteBuffer> PAYLOAD_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(30).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private final int tableId;
    private final int partitionId;
    private final Slice upperBound;
    final ColumnFamilyHandle partCf;
    final ColumnFamilyHandle dataCf;
    final ReadOptions upperBoundReadOpts;
    final ReadOptions scanReadOpts;
    final LockByRowId lockByRowId = new LockByRowId();
    private final byte[] partitionStartPrefix;
    private final byte[] partitionEndPrefix;

    PartitionDataHelper(int tableId, int partitionId, ColumnFamilyHandle partCf, ColumnFamilyHandle dataCf) {
        this.tableId = tableId;
        this.partitionId = partitionId;
        this.partCf = partCf;
        this.dataCf = dataCf;
        this.partitionStartPrefix = PartitionDataHelper.compositeKey(tableId, partitionId);
        this.partitionEndPrefix = RocksUtils.incrementPrefix(this.partitionStartPrefix);
        this.upperBound = new Slice(this.partitionEndPrefix);
        this.upperBoundReadOpts = new ReadOptions().setIterateUpperBound((AbstractSlice)this.upperBound);
        this.scanReadOpts = new ReadOptions().setIterateUpperBound((AbstractSlice)this.upperBound).setAutoPrefixMode(true);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public byte[] partitionStartPrefix() {
        return this.partitionStartPrefix;
    }

    public byte[] partitionEndPrefix() {
        return this.partitionEndPrefix;
    }

    void putCommittedDataIdKey(ByteBuffer buffer, RowId rowId, HybridTimestamp timestamp) {
        assert (buffer.order() == RocksDbStorageUtils.KEY_BYTE_ORDER);
        assert (rowId.partitionId() == this.partitionId) : "rowPartitionId=" + rowId.partitionId() + ", storagePartitionId=" + this.partitionId;
        buffer.putInt(this.tableId);
        buffer.putShort((short)this.partitionId);
        RocksDbStorageUtils.putRowIdUuid(buffer, rowId.uuid());
        PartitionDataHelper.putTimestampDesc(buffer, timestamp);
        buffer.flip();
    }

    void putGcKey(ByteBuffer gcKeyBuffer, RowId rowId, HybridTimestamp timestamp) {
        assert (gcKeyBuffer.order() == RocksDbStorageUtils.KEY_BYTE_ORDER);
        assert (rowId.partitionId() == this.partitionId) : "rowPartitionId=" + rowId.partitionId() + ", storagePartitionId=" + this.partitionId;
        gcKeyBuffer.putInt(this.tableId);
        gcKeyBuffer.putShort((short)this.partitionId);
        PartitionDataHelper.putTimestampNatural(gcKeyBuffer, timestamp);
        RocksDbStorageUtils.putRowIdUuid(gcKeyBuffer, rowId.uuid());
        gcKeyBuffer.flip();
    }

    void putRowId(ByteBuffer keyBuffer, RowId rowId) {
        assert (rowId.partitionId() == this.partitionId) : "rowPartitionId=" + rowId.partitionId() + ", storagePartitionId=" + this.partitionId;
        RocksDbStorageUtils.putRowIdUuid(keyBuffer, rowId.uuid());
    }

    RowId getRowId(ByteBuffer keyBuffer, int offset) {
        assert (this.partitionId == (keyBuffer.getShort(4) & 0xFFFF));
        return new RowId(this.partitionId, RocksDbStorageUtils.getRowIdUuid(keyBuffer, offset));
    }

    @Nullable
    static WriteBatchWithIndex currentWriteBatch() {
        ThreadLocalState state = THREAD_LOCAL_STATE.get();
        return state == null ? null : state.batch;
    }

    public static WriteBatchWithIndex requireWriteBatch() {
        ThreadLocalState state = THREAD_LOCAL_STATE.get();
        assert (state != null) : "Attempting to write data outside of data access closure.";
        return state.batch;
    }

    public static byte[] compositeKey(int tableOrIndexId, int partitionId) {
        return ByteBuffer.allocate(6).order(RocksDbStorageUtils.KEY_BYTE_ORDER).putInt(tableOrIndexId).putShort((short)partitionId).array();
    }

    static void putTimestampDesc(ByteBuffer buf, HybridTimestamp ts) {
        assert (buf.order() == RocksDbStorageUtils.KEY_BYTE_ORDER);
        buf.putLong(ts.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static HybridTimestamp readTimestampDesc(ByteBuffer keyBuf) {
        assert (keyBuf.order() == RocksDbStorageUtils.KEY_BYTE_ORDER);
        long time = keyBuf.getLong(22) ^ 0xFFFFFFFFFFFFFFFFL;
        return HybridTimestamp.hybridTimestamp(time);
    }

    static void putTimestampNatural(ByteBuffer buf, HybridTimestamp ts) {
        assert (buf.order() == RocksDbStorageUtils.KEY_BYTE_ORDER);
        buf.putLong(ts.longValue());
    }

    static HybridTimestamp readTimestampNatural(ByteBuffer keyBuf, int offset) {
        assert (keyBuf.order() == RocksDbStorageUtils.KEY_BYTE_ORDER);
        long time = keyBuf.getLong(offset);
        return HybridTimestamp.hybridTimestamp(time);
    }

    static RocksIterator wrapIterator(RocksIterator it, ColumnFamilyHandle cf) {
        return PartitionDataHelper.wrapIterator(it, PartitionDataHelper.currentWriteBatch(), cf);
    }

    static RocksIterator wrapIterator(RocksIterator it, @Nullable WriteBatchWithIndex writeBatch, ColumnFamilyHandle cf) {
        if (writeBatch != null && writeBatch.count() > 0) {
            return writeBatch.newIteratorWithBase(cf, it);
        }
        return it;
    }

    static byte @Nullable [] getFromBatchAndDb(RocksDB db, ColumnFamilyHandle cfHandle, ReadOptions readOptions, byte[] key) throws RocksDBException {
        return PartitionDataHelper.getFromBatchAndDb(db, PartitionDataHelper.currentWriteBatch(), cfHandle, readOptions, key);
    }

    static byte @Nullable [] getFromBatchAndDb(RocksDB db, @Nullable WriteBatchWithIndex writeBatch, ColumnFamilyHandle cfHandle, ReadOptions readOptions, byte[] key) throws RocksDBException {
        return writeBatch == null || writeBatch.count() == 0 ? db.get(cfHandle, readOptions, key) : writeBatch.getFromBatchAndDB(db, cfHandle, readOptions, key);
    }

    static BinaryRow deserializeRow(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        return PartitionDataHelper.deserializeRow(buffer);
    }

    static BinaryRow deserializeRow(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.BIG_ENDIAN);
        int schemaVersion = Short.toUnsignedInt(buffer.getShort());
        ByteBuffer binaryTupleSlice = buffer.slice().order(BinaryTuple.ORDER);
        return new BinaryRowImpl(schemaVersion, binaryTupleSlice);
    }

    byte[] createPayloadKey(ByteBuffer dataId) {
        byte[] result = PAYLOAD_KEY_BUFFER.get().clear().putInt(this.tableId).putShort((short)this.partitionId).put(dataId).array();
        dataId.rewind();
        PartitionDataHelper.setFirstBit(result, result.length - 1, false);
        return result;
    }

    static void setFirstBit(byte[] array, int index, boolean value) {
        if (value) {
            int n = index;
            array[n] = (byte)(array[n] | 1);
        } else {
            int n = index;
            array[n] = (byte)(array[n] & 0xFE);
        }
    }

    static boolean isTombstone(ByteBuffer dataId) {
        byte lastByte = dataId.get(dataId.limit() - 1);
        return (lastByte & 1) != 0;
    }

    static boolean isTombstone(byte[] dataId) {
        byte lastByte = dataId[dataId.length - 1];
        return (lastByte & 1) != 0;
    }

    @Override
    public void close() {
        RocksUtils.closeAll(new AbstractNativeReference[]{this.scanReadOpts, this.upperBoundReadOpts, this.upperBound});
    }
}

