/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.jetbrains.annotations.Nullable;

public class HybridTimestamps {
    @Nullable
    public static HybridTimestamp readTimestamp(long pageAddr, int offset) {
        long time = PageUtils.getLong(pageAddr, offset);
        return HybridTimestamp.nullableHybridTimestamp(time);
    }

    public static int writeTimestampToMemory(long addr, int offset, @Nullable HybridTimestamp timestamp) {
        PageUtils.putLong(addr, offset, HybridTimestamp.hybridTimestampToLong(timestamp));
        return 8;
    }

    public static void writeTimestampToBuffer(ByteBuffer buffer, @Nullable HybridTimestamp timestamp) {
        buffer.putLong(HybridTimestamp.hybridTimestampToLong(timestamp));
    }
}

