/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rocksdb.snapshot;

import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.jetbrains.annotations.Nullable;

public class ColumnFamilyRange {
    private final ColumnFamily columnFamily;
    private final byte @Nullable [] lowerBound;
    private final byte @Nullable [] upperBound;

    private ColumnFamilyRange(ColumnFamily columnFamily, byte @Nullable [] lowerBound, byte @Nullable [] upperBound) {
        this.columnFamily = columnFamily;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public static ColumnFamilyRange fullRange(ColumnFamily columnFamily) {
        return new ColumnFamilyRange(columnFamily, null, null);
    }

    public static ColumnFamilyRange range(ColumnFamily columnFamily, byte[] lowerBound, byte[] upperBound) {
        assert (lowerBound != null && upperBound != null);
        return new ColumnFamilyRange(columnFamily, lowerBound, upperBound);
    }

    public ColumnFamily columnFamily() {
        return this.columnFamily;
    }

    public byte @Nullable [] lowerBound() {
        return this.lowerBound;
    }

    public byte @Nullable [] upperBound() {
        return this.upperBound;
    }

    public boolean isFullRange() {
        return this.lowerBound == null && this.upperBound == null;
    }
}

