/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.lowwatermark;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.lowwatermark.LowWatermarkImpl;
import org.apache.ignite3.internal.util.ExceptionUtils;

class ScheduledUpdateLowWatermarkTask
implements Runnable {
    private final LowWatermarkImpl lowWatermarkImpl;
    private final AtomicReference<State> state;

    ScheduledUpdateLowWatermarkTask(LowWatermarkImpl lowWatermarkImpl, State state) {
        this.lowWatermarkImpl = lowWatermarkImpl;
        this.state = new AtomicReference<State>(state);
    }

    @Override
    public void run() {
        if (this.state.compareAndSet(State.NEW, State.IN_PROGRESS)) {
            this.lowWatermarkImpl.updateLowWatermarkAsync(this.lowWatermarkImpl.createNewLowWatermarkCandidate()).whenCompleteAsync((unused, throwable) -> {
                if (this.state.compareAndSet(State.IN_PROGRESS, State.COMPLETED) && !ExceptionUtils.hasCause(throwable, NodeStoppingException.class)) {
                    this.lowWatermarkImpl.scheduleUpdates();
                }
            });
        }
    }

    boolean tryCancel() {
        return this.state.compareAndSet(State.NEW, State.CANCELLED);
    }

    State state() {
        return this.state.get();
    }

    static enum State {
        NEW,
        IN_PROGRESS,
        COMPLETED,
        CANCELLED;

    }
}

