/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.disaster.system;

import java.util.UUID;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterStatePersistentSerializer;
import org.apache.ignite3.internal.disaster.system.ResetClusterMessagePersistentSerializer;
import org.apache.ignite3.internal.disaster.system.message.ResetClusterMessage;
import org.apache.ignite3.internal.disaster.system.storage.ClusterResetStorage;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.vault.VaultEntry;
import org.apache.ignite3.internal.vault.VaultManager;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.jetbrains.annotations.Nullable;

public class SystemDisasterRecoveryStorage
implements ClusterResetStorage {
    private static final ByteArray INIT_CONFIG_APPLIED_VAULT_KEY = new ByteArray("systemRecovery.initConfigApplied");
    private static final ByteArray CLUSTER_STATE_VAULT_KEY = new ByteArray("systemRecovery.clusterState");
    private static final ByteArray RESET_CLUSTER_MESSAGE_VAULT_KEY = new ByteArray("systemRecovery.resetClusterMessage");
    private static final ByteArray WITNESSED_METASTORAGE_REPAIR_CLUSTER_ID_VAULT_KEY = new ByteArray("systemRecovery.witnessedMetastorageRepairClusterId");
    private final VaultManager vault;
    private volatile ResetClusterMessage volatileResetClusterMessage;

    public SystemDisasterRecoveryStorage(VaultManager vault) {
        this.vault = vault;
    }

    @Override
    @Nullable
    public ResetClusterMessage readResetClusterMessage() {
        VaultEntry entry = this.vault.get(RESET_CLUSTER_MESSAGE_VAULT_KEY);
        return entry != null ? VersionedSerialization.fromBytes(entry.value(), ResetClusterMessagePersistentSerializer.INSTANCE) : null;
    }

    @Override
    public void removeResetClusterMessage() {
        this.vault.remove(RESET_CLUSTER_MESSAGE_VAULT_KEY);
    }

    @Override
    public void saveVolatileResetClusterMessage(ResetClusterMessage message) {
        this.volatileResetClusterMessage = message;
    }

    @Nullable
    public ClusterState readClusterState() {
        VaultEntry entry = this.vault.get(CLUSTER_STATE_VAULT_KEY);
        return entry != null ? VersionedSerialization.fromBytes(entry.value(), ClusterStatePersistentSerializer.INSTANCE) : null;
    }

    void saveClusterState(ClusterState clusterState) {
        this.vault.put(CLUSTER_STATE_VAULT_KEY, VersionedSerialization.toBytes(clusterState, ClusterStatePersistentSerializer.INSTANCE));
    }

    boolean isInitConfigApplied() {
        VaultEntry appliedEntry = this.vault.get(INIT_CONFIG_APPLIED_VAULT_KEY);
        return appliedEntry != null;
    }

    void markInitConfigApplied() {
        this.vault.put(INIT_CONFIG_APPLIED_VAULT_KEY, ArrayUtils.BYTE_EMPTY_ARRAY);
    }

    void saveResetClusterMessage(ResetClusterMessage message) {
        this.vault.put(RESET_CLUSTER_MESSAGE_VAULT_KEY, VersionedSerialization.toBytes(message, ResetClusterMessagePersistentSerializer.INSTANCE));
    }

    @Override
    @Nullable
    public ResetClusterMessage readVolatileResetClusterMessage() {
        return this.volatileResetClusterMessage;
    }

    @Override
    @Nullable
    public UUID readWitnessedMetastorageRepairClusterId() {
        VaultEntry entry = this.vault.get(WITNESSED_METASTORAGE_REPAIR_CLUSTER_ID_VAULT_KEY);
        return entry != null ? ByteUtils.bytesToUuid(entry.value()) : null;
    }

    @Override
    public void saveWitnessedMetastorageRepairClusterId(UUID repairClusterId) {
        this.vault.put(WITNESSED_METASTORAGE_REPAIR_CLUSTER_ID_VAULT_KEY, ByteUtils.uuidToBytes(repairClusterId));
    }
}

