/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite3.internal.catalog.storage.SnapshotEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateLog;
import org.apache.ignite3.internal.catalog.storage.UpdateLogEvent;
import org.apache.ignite3.internal.catalog.storage.VersionedUpdate;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogMarshallerException;
import org.apache.ignite3.internal.catalog.storage.serialization.UpdateLogMarshaller;
import org.apache.ignite3.internal.catalog.storage.serialization.UpdateLogMarshallerImpl;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.EntryEvent;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.Revisions;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.WatchListener;
import org.apache.ignite3.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Iif;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.metastorage.dsl.StatementResult;
import org.apache.ignite3.internal.metastorage.dsl.Statements;
import org.apache.ignite3.internal.metastorage.dsl.Update;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class UpdateLogImpl
implements UpdateLog {
    private static final byte[] MAGIC_BYTES = "IGNITE".getBytes(StandardCharsets.UTF_8);
    public static final ByteArray CATALOG_UPDATE_PREFIX = ByteArray.fromString("catalog.update.");
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final MetaStorageManager metastore;
    private final FailureProcessor failureProcessor;
    private final UpdateLogMarshaller marshaller;
    private volatile UpdateLog.OnUpdateHandler onUpdateHandler;
    @Nullable
    private volatile UpdateListener listener;

    public UpdateLogImpl(MetaStorageManager metastore, FailureProcessor failureProcessor) {
        this.metastore = metastore;
        this.failureProcessor = failureProcessor;
        this.marshaller = new UpdateLogMarshallerImpl(2);
    }

    @TestOnly
    public UpdateLogImpl(MetaStorageManager metastore, FailureProcessor failureProcessor, UpdateLogMarshaller marshaller) {
        this.metastore = metastore;
        this.failureProcessor = failureProcessor;
        this.marshaller = marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            UpdateListener listener;
            UpdateLog.OnUpdateHandler handler = this.onUpdateHandler;
            if (handler == null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Handler must be registered prior to component start");
            }
            this.recoverStateFromMetastore(handler);
            this.listener = listener = new UpdateListener(handler, this.marshaller);
            this.metastore.registerPrefixWatch(CatalogKey.updatePrefix(), listener);
            Entry existingKey = this.metastore.getLocally(CatalogKey.catalogProduct());
            if (existingKey.empty()) {
                Update putProductKey = Operations.ops(Operations.put(CatalogKey.catalogProduct(), MAGIC_BYTES)).yield(false);
                Iif writeProductKeyIfNotExist = Statements.iif((Condition)Conditions.notExists(CatalogKey.catalogProduct()), putProductKey, Operations.ops(new Operation[0]).yield(false));
                CompletionStage completionStage = this.metastore.invoke(writeProductKeyIfNotExist).thenApply(ignore -> null);
                return completionStage;
            }
            CompletableFuture<Void> completableFuture = CompletableFutures.nullCompletedFuture();
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        UpdateListener listener = this.listener;
        this.listener = null;
        if (listener != null) {
            this.metastore.unregisterWatch(listener);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public synchronized void registerUpdateHandler(UpdateLog.OnUpdateHandler handler) {
        if (this.onUpdateHandler != null) {
            throw new IllegalStateException("onUpdateHandler handler already registered");
        }
        this.onUpdateHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> append(VersionedUpdate update) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            int newVersion = update.version();
            int expectedVersion = newVersion - 1;
            CompoundCondition versionAsExpected = Conditions.or(Conditions.notExists(CatalogKey.currentVersion()), Conditions.value(CatalogKey.currentVersion()).eq(ByteUtils.intToBytesKeepingOrder(expectedVersion)));
            Update appendUpdateEntryAndBumpVersion = Operations.ops(Operations.put(CatalogKey.update(newVersion), this.marshaller.marshall(update)), Operations.put(CatalogKey.currentVersion(), ByteUtils.intToBytesKeepingOrder(newVersion))).yield(true);
            Iif iif = Statements.iif((Condition)versionAsExpected, appendUpdateEntryAndBumpVersion, Operations.ops(new Operation[0]).yield(false));
            CompletionStage completionStage = this.metastore.invoke(iif).thenApply(StatementResult::getAsBoolean);
            return completionStage;
        }
        catch (CatalogMarshallerException ex) {
            this.failureProcessor.process(new FailureContext(ex, "Failed to append update log."));
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(ex);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> saveSnapshot(SnapshotEntry update) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            int oldSnapshotVersion;
            int snapshotVersion = update.version();
            Entry oldSnapshotEntry = this.metastore.getLocally(CatalogKey.snapshotVersion(), this.metastore.appliedRevision());
            int n = oldSnapshotVersion = oldSnapshotEntry.empty() ? 1 : ByteUtils.bytesToIntKeepingOrder(Objects.requireNonNull(oldSnapshotEntry.value()));
            if (oldSnapshotVersion >= snapshotVersion) {
                CompletableFuture<Boolean> completableFuture = CompletableFutures.falseCompletedFuture();
                return completableFuture;
            }
            byte[] snapshotVersionValue = ByteUtils.intToBytesKeepingOrder(snapshotVersion);
            CompoundCondition versionIsRecent = Conditions.or(Conditions.notExists(CatalogKey.snapshotVersion()), Conditions.value(CatalogKey.snapshotVersion()).lt(snapshotVersionValue));
            Update saveSnapshotAndDropOutdatedUpdates = Operations.ops((Operation[])Stream.concat(Stream.of(Operations.put(CatalogKey.snapshotVersion(), snapshotVersionValue), Operations.put(CatalogKey.update(snapshotVersion), this.marshaller.marshall(update))), IntStream.range(oldSnapshotVersion, snapshotVersion).mapToObj(ver -> Operations.remove(CatalogKey.update(ver)))).toArray(Operation[]::new)).yield(true);
            Iif iif = Statements.iif((Condition)versionIsRecent, saveSnapshotAndDropOutdatedUpdates, Operations.ops(new Operation[0]).yield(false));
            CompletionStage completionStage = this.metastore.invoke(iif).thenApply(StatementResult::getAsBoolean);
            return completionStage;
        }
        catch (CatalogMarshallerException ex) {
            this.failureProcessor.process(new FailureContext(ex, "Failed to append update log."));
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(ex);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void recoverStateFromMetastore(UpdateLog.OnUpdateHandler handler) {
        CompletableFuture<Revisions> recoveryFinishedFuture = this.metastore.recoveryFinishedFuture();
        assert (recoveryFinishedFuture.isDone());
        long recoveryRevision = recoveryFinishedFuture.join().revision();
        Entry earliestVersion = this.metastore.getLocally(CatalogKey.snapshotVersion(), recoveryRevision);
        int ver = earliestVersion.empty() ? 1 : ByteUtils.bytesToIntKeepingOrder(Objects.requireNonNull(earliestVersion.value()));
        this.recoverUpdates(handler, recoveryRevision, ver);
    }

    private void recoverUpdates(UpdateLog.OnUpdateHandler handler, long recoveryRevision, int ver) {
        ByteArray key;
        Entry entry;
        while (!(entry = this.metastore.getLocally(key = CatalogKey.update(ver++), recoveryRevision)).empty() && !entry.tombstone()) {
            UpdateLogEvent update = this.marshaller.unmarshall(Objects.requireNonNull(entry.value()));
            handler.handle(update, entry.timestamp(), entry.revision());
        }
    }

    private class UpdateListener
    implements WatchListener {
        private final UpdateLog.OnUpdateHandler onUpdateHandler;
        private final UpdateLogMarshaller marshaller;

        private UpdateListener(UpdateLog.OnUpdateHandler onUpdateHandler, UpdateLogMarshaller marshaller) {
            this.onUpdateHandler = onUpdateHandler;
            this.marshaller = marshaller;
        }

        @Override
        public CompletableFuture<Void> onUpdate(WatchEvent event) {
            Collection<EntryEvent> entryEvents = event.entryEvents();
            ArrayList<CompletableFuture<Void>> handleFutures = new ArrayList<CompletableFuture<Void>>(entryEvents.size());
            for (EntryEvent eventEntry : entryEvents) {
                if (eventEntry.newEntry().tombstone()) continue;
                byte[] payload = eventEntry.newEntry().value();
                assert (payload != null) : eventEntry;
                try {
                    UpdateLogEvent update = this.marshaller.unmarshall(payload);
                    handleFutures.add(this.onUpdateHandler.handle(update, event.timestamp(), event.revision()));
                }
                catch (CatalogMarshallerException ex) {
                    UpdateLogImpl.this.failureProcessor.process(new FailureContext(ex, "Failed to deserialize update."));
                    return CompletableFuture.failedFuture(ex);
                }
            }
            return CompletableFuture.allOf((CompletableFuture[])handleFutures.toArray(CompletableFuture[]::new));
        }
    }

    private static class CatalogKey {
        private CatalogKey() {
            throw new AssertionError();
        }

        static ByteArray currentVersion() {
            return ByteArray.fromString("catalog.version");
        }

        static ByteArray update(int version) {
            return ByteArray.fromString("catalog.update." + version);
        }

        static ByteArray updatePrefix() {
            return CATALOG_UPDATE_PREFIX;
        }

        static ByteArray snapshotVersion() {
            return ByteArray.fromString("catalog.snapshot.version");
        }

        static ByteArray catalogProduct() {
            return ByteArray.fromString("catalog.product");
        }
    }
}

