/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.encryption;

import java.util.List;
import java.util.function.Consumer;
import org.apache.ignite.internal.management.encryption.CacheGroupEncryptionCommand;
import org.apache.ignite.internal.management.encryption.CacheGroupEncryptionTaskResult;
import org.apache.ignite.internal.management.encryption.EncryptionCacheGroupArg;
import org.apache.ignite.internal.management.encryption.EncryptionKeyIdsTask;
import org.apache.ignite.internal.util.typedef.F;

public class EncryptionCacheKeyIdsCommand
extends CacheGroupEncryptionCommand<List<Integer>> {
    @Override
    public String description() {
        return "View encryption key identifiers of the cache group";
    }

    @Override
    public Class<EncryptionCacheGroupArg> argClass() {
        return EncryptionCacheGroupArg.class;
    }

    @Override
    public Class<EncryptionKeyIdsTask> taskClass() {
        return EncryptionKeyIdsTask.class;
    }

    @Override
    public void printResult(EncryptionCacheGroupArg arg, CacheGroupEncryptionTaskResult<List<Integer>> res, Consumer<String> printer) {
        printer.accept("Encryption key identifiers for cache: " + arg.cacheGroupName());
        super.printResult(arg, res, printer);
    }

    @Override
    protected void printNodeResult(List<Integer> res, String grpName, Consumer<String> printer) {
        if (F.isEmpty(res)) {
            printer.accept("    ---");
            return;
        }
        for (int i = 0; i < res.size(); ++i) {
            printer.accept("    " + res.get(i) + (i == 0 ? " (active)" : ""));
        }
    }
}

