/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NumericInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DoubleIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class DoubleInlineIndexKeyType
extends NumericInlineIndexKeyType<DoubleIndexKey> {
    public DoubleInlineIndexKeyType() {
        super(IndexKeyType.DOUBLE, (short)8);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        double val = Double.longBitsToDouble(PageUtils.getLong(pageAddr, off + 1));
        return -Integer.signum(((NumericIndexKey)key).compareTo(val));
    }

    @Override
    protected int put0(long pageAddr, int off, DoubleIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putLong(pageAddr, off + 1, Double.doubleToLongBits((Double)key.key()));
        return this.keySize + 1;
    }

    @Override
    protected DoubleIndexKey get0(long pageAddr, int off) {
        double key = Double.longBitsToDouble(PageUtils.getLong(pageAddr, off + 1));
        return new DoubleIndexKey(key);
    }
}

