/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.DeprecationReporter;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.commandline.Arg;
import org.apache.rat.commandline.ArgumentContext;
import org.apache.rat.commandline.StyleSheets;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.document.FileDocument;
import org.apache.rat.help.Licenses;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.rat.walker.ArchiveWalker;
import org.apache.rat.walker.DirectoryWalker;

public final class OptionCollection {
    public static final Comparator<Option> OPTION_COMPARATOR = new OptionComparator();
    public static final Option HELP = new Option("?", "help", false, "Print help for the RAT command line interface and exit.");
    public static final Option HELP_LICENSES = Option.builder().longOpt("help-licenses").desc("Print help for the RAT command line interface and exit.").build();
    private static final Map<String, Supplier<String>> ARGUMENT_TYPES = new TreeMap<String, Supplier<String>>();

    private OptionCollection() {
    }

    public static Map<String, Supplier<String>> getArgumentTypes() {
        return Collections.unmodifiableMap(ARGUMENT_TYPES);
    }

    private static String asString(Object[] args) {
        return Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
    }

    public static ReportConfiguration parseCommands(String[] args, Consumer<Options> helpCmd) throws IOException {
        return OptionCollection.parseCommands(args, helpCmd, false);
    }

    public static ReportConfiguration parseCommands(String[] args, Consumer<Options> helpCmd, boolean noArgs) throws IOException {
        CommandLine commandLine;
        Options opts = OptionCollection.buildOptions();
        try {
            commandLine = DefaultParser.builder().setDeprecatedHandler(DeprecationReporter.getLogReporter()).setAllowPartialMatching(true).build().parse(opts, args);
        }
        catch (ParseException e) {
            DefaultLog.getInstance().error(e.getMessage());
            DefaultLog.getInstance().error("Please use the \"--help\" option to see a list of valid commands and options.", e);
            System.exit(1);
            return null;
        }
        Arg.processLogLevel(commandLine);
        if (commandLine.hasOption(HELP)) {
            helpCmd.accept(opts);
            return null;
        }
        if (commandLine.hasOption(HELP_LICENSES)) {
            new Licenses(OptionCollection.createConfiguration(null, commandLine), new PrintWriter(System.out)).printHelp();
            return null;
        }
        if (commandLine.hasOption(HELP_LICENSES)) {
            new Licenses(OptionCollection.createConfiguration(null, commandLine), new PrintWriter(System.out)).printHelp();
            return null;
        }
        if (commandLine.hasOption(Arg.HELP_LICENSES.option())) {
            new Licenses(OptionCollection.createConfiguration(null, commandLine), new PrintWriter(System.out)).printHelp();
            return null;
        }
        String[] clArgs = new String[]{null};
        ArrayList<String> lst = new ArrayList<String>();
        String dirValue = commandLine.getOptionValue(Arg.DIR.getSelected());
        if (dirValue != null) {
            lst.add(dirValue);
        }
        lst.addAll(Arrays.asList(commandLine.getArgs()));
        if (!noArgs && lst.size() != 1) {
            if (lst.isEmpty()) {
                DefaultLog.getInstance().error("No directories or files specified for scanning.  Did you forget to close a multi-argument option?");
            } else {
                DefaultLog.getInstance().error("Too many directories or files specified for scanning.");
            }
            helpCmd.accept(opts);
            return null;
        }
        if (!lst.isEmpty()) {
            clArgs[0] = (String)lst.get(0);
        }
        return OptionCollection.createConfiguration(clArgs[0], commandLine);
    }

    static ReportConfiguration createConfiguration(String baseDirectory, CommandLine cl) {
        ReportConfiguration configuration = new ReportConfiguration();
        new ArgumentContext(configuration, cl).processArgs();
        if (StringUtils.isNotBlank(baseDirectory)) {
            configuration.setReportable(OptionCollection.getReportable(new File(baseDirectory), configuration));
        }
        return configuration;
    }

    public static Options buildOptions() {
        return Arg.getOptions().addOption(HELP);
    }

    static IReportable getReportable(File base, ReportConfiguration config) {
        FileDocument doc;
        File absBase = base.getAbsoluteFile();
        DocumentName documentName = new DocumentName(absBase);
        if (!absBase.exists()) {
            DefaultLog.getInstance().error("Directory '" + documentName + "' does not exist.");
            return null;
        }
        DocumentNameMatcher documentNameMatcher = config.getNameMatcher(documentName);
        if (!documentNameMatcher.matches((doc = new FileDocument(documentName, absBase, documentNameMatcher)).getName())) {
            DefaultLog.getInstance().error("Directory '" + documentName + "' is in excluded list.");
            return null;
        }
        if (absBase.isDirectory()) {
            return new DirectoryWalker(doc);
        }
        return new ArchiveWalker(doc);
    }

    static {
        ARGUMENT_TYPES.put("File", () -> "A file name.");
        ARGUMENT_TYPES.put("Integer", () -> "An integer value.");
        ARGUMENT_TYPES.put("DirOrArchive", () -> "A directory or archive file to scan.");
        ARGUMENT_TYPES.put("Expression", () -> "A file matching pattern usually of the form used in Ant build files and '.gitignore' files (see https://ant.apache.org/manual/dirtasks.html#patterns for examples). Regular expression patterns may be specified by surrounding the pattern with '%regex[' and ']'. For example '%regex[[A-Z].*]' would match files and directories that start with uppercase latin letters.");
        ARGUMENT_TYPES.put("LicenseFilter", () -> String.format("A defined filter for the licenses to include. Valid values: %s.", OptionCollection.asString((Object[])LicenseSetFactory.LicenseFilter.values())));
        ARGUMENT_TYPES.put("LogLevel", () -> String.format("The log level to use. Valid values %s.", OptionCollection.asString((Object[])Log.Level.values())));
        ARGUMENT_TYPES.put("ProcessingType", () -> String.format("Specifies how to process file types. Valid values are: %s%n", Arrays.stream(ReportConfiguration.Processing.values()).map(v -> String.format("\t%s: %s", v.name(), v.desc())).collect(Collectors.joining(System.lineSeparator()))));
        ARGUMENT_TYPES.put("StyleSheet", () -> String.format("Either an external xsl file or one of the internal named sheets. Internal sheets are: %s", Arrays.stream(StyleSheets.values()).map(v -> String.format("\t%s: %s", v.arg(), v.desc())).collect(Collectors.joining(System.lineSeparator()))));
        ARGUMENT_TYPES.put("LicenseID", () -> "The ID for a license.");
        ARGUMENT_TYPES.put("FamilyID", () -> "The ID for a license family.");
        ARGUMENT_TYPES.put("StandardCollection", () -> String.format("Defines standard expression patterns (see above). Valid values are: %s%n", Arrays.stream(StandardCollection.values()).map(v -> String.format("\t%s: %s", v.name(), v.desc())).collect(Collectors.joining(System.lineSeparator()))));
        ARGUMENT_TYPES.put("CounterPattern", () -> String.format("A pattern comprising one of the following prefixes followed by a colon and a count (e.g. %s:5).  Prefixes are %n%s.", new Object[]{ClaimStatistic.Counter.UNAPPROVED, Arrays.stream(ClaimStatistic.Counter.values()).map(v -> String.format("\t%s: %s Default range [%s, %s]", v.name(), v.getDescription(), v.getDefaultMinValue(), v.getDefaultMaxValue() == -1 ? "unlimited" : Integer.valueOf(v.getDefaultMaxValue()))).collect(Collectors.joining(System.lineSeparator()))}));
    }

    private static class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private static final long serialVersionUID = 5305467873966684014L;

        private OptionComparator() {
        }

        private String getKey(Option opt) {
            String key = opt.getOpt();
            key = key == null ? opt.getLongOpt() : key;
            return key;
        }

        @Override
        public int compare(Option opt1, Option opt2) {
            return this.getKey(opt1).compareToIgnoreCase(this.getKey(opt2));
        }
    }
}

