#!/usr/local/bin/perl

# -----------------------------------------------------------------------------
#    
#           Some routines to facilitate creation of 
#            vt100 pseudo-menu driven interface
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.
# 
#  Works under xterm, shelltool, but not commandtool. 
#   
#  by Isaac Tsai
# -----------------------------------------------------------------------------
#  
sub  C_ClearScreen { print "\e[;H\e[2J"; }
sub  C_EraseLine   { print "\e[K"; }
sub  C_MoveTo      { local($y,$x)=@_; print "\e[$y;$x"; print "H"; }
sub  C_MakeBox     { 
    local($y1,$x1,$y2,$x2,$title)=@_;
    local($wd)=$x2-$x1;	
    local($j,$tlen);

    if(x2 >= 0 && x2 <= 80) {
      C_MoveTo($y1,$x1);
      print "+"; print "-" x ($wd-1); print "+";
      if( $title ne "" ) {
        $tlen = length($title); $j = int($x1+($wd - $tlen)/2);
        C_MoveTo($y1,$j); print $title;
      }
      for ($j=$y1+1;$j<$y2;$j++) { 
        C_MoveTo($j,$x1);
        print "|"; print " " x ($wd-1) ;  print "|"; 
      }
      C_MoveTo($y2,$x1);
      print "+"; print "-" x ($wd-1); print "+";
    }
 }

# the coordnate of the upper left corner (y, x)
# the width of the box
# one line message appear on a separate top box
# one line title on top of the choice box
# choice list
sub  C_MultipleChoice {
    local($y1,$x1,$wd,$msg,$title,@items)=@_;
    local($item_cnt)=$#items;
    local($j,$off_y,$idx,$u_in,$done,$msg_out);
    $idx="1"; $off_y = 0;

    C_ClearScreen;
    if( $msg ne "" ) {
      # C_MakeBox($y1,$x1,$y1+2,$x1+length($msg)+2);
      C_MakeBox($y1,$x1,$y1+2,$x1+$wd);
      C_MoveTo($y1+1,$x1+1); print $msg;
      $off_y = 4;
    }
    C_MakeBox($y1+$off_y,$x1,$y1+$off_y+$item_cnt+5,$x1+$wd,$title);
    for ($j=0;$j<=$item_cnt;$j++) {
      C_MoveTo($y1+$off_y+$j+2,$x1+2); printf "%2d: %s", $idx,$items[$j];
      $idx++;
    }
    $off_y = $off_y + 4;
    $done = 0;
    while ( $done ne "y" && $done ne "yes" ) {
      $u_in=0; 
      while ($u_in < 1 || $u_in > $item_cnt+1 || $u_in =~ /\D/ || $u_in == "") { 
        C_MoveTo($y1+$off_y+$item_cnt,$x1+1); &C_EraseLine;
        C_MoveTo($y1+$off_y+$item_cnt,$x1+1); print "SELECT:" . " " x ($wd-8) . "|";
        C_MoveTo($y1+$off_y+$item_cnt,$x1+8);
        $u_in=<>; chop($u_in); 
      }
      $msg_out = "Selected item: " . $u_in . " $items[$u_in-1]" . ", (Y <RETURN>, or N)? ";
      $j = length($msg_out);
      C_MoveTo($y1+$off_y+$item_cnt+2,$x1); &C_EraseLine;
      C_MoveTo($y1+$off_y+$item_cnt+2,$x1);
      print $msg_out;
      C_MoveTo($y1+$off_y+$item_cnt+2,$x1+$j);
      $done=<>; chop($done); $done =~ tr/A-Z/a-z/;
      if( length($done) == 0 ) { $done = 'y'; };
    }
  return $u_in;
 }

sub  C_InputData {
    local($y,$x,$wd,$title,$limit_len,$prompt,@msgs)=@_;
    local($line_cnt)=$#msgs;
    local($done);
    local($jj,$prom_length);
    local($input,$in_len,$msgout,$msglen);
    
    C_ClearScreen;
    C_MakeBox($y,$x,$y+$line_cnt+2,$x+$wd,$title);
    for($jj=0;$jj<=$line_cnt;$jj++) {
      C_MoveTo($y+$jj+1,$x+1); print " $msgs[$jj]";
    }
    C_MakeBox($y+$line_cnt+4,$x,$y+$line_cnt+6,$x+$wd,"");
    C_MoveTo($y+$line_cnt+5,$x+1); print $prompt;
    $done = 0; $prom_length = length($prompt);
    while( $done ne "y" && $done ne "yes" ) {
      $in_len = 0;
      while(($in_len < 1) || ($in_len > $limit_len) ) {
        C_MoveTo($y+$line_cnt+5, $x+length($prompt)+1); &C_EraseLine;
        C_MoveTo($y+$line_cnt+5, $x+1); 
        print $prompt . " " x ($wd - $prom_length - 1) . "|";
        C_MoveTo($y+$line_cnt+5, $x+length($prompt)+1);
        $input = <>; chop($input); $in_len = length($input);
      }
      $msgout = "You entered:\'" . $input . "\', Are you sure (Y or N)? ";
      C_MoveTo($y+$line_cnt+7,$x); &C_EraseLine;
      C_MoveTo($y+$line_cnt+7,$x); print $msgout;
      $msglen = length($msgout);
      C_MoveTo($y+$line_cnt+7,$x+$msglen);
      $done = <>; chop($done); $done =~ tr/A-Z/a-z/;
    }
    return $input;
 }

sub  C_InputSetNum {
    local($y,$x,$wd,$title,$limit_len,$prompt,@msgs)=@_;
    local($line_cnt)=$#msgs;
    local($done);
    local($jj,$prom_length);
    local($input,$in_len,$msgout,$msglen);
    
    C_ClearScreen;
    C_MakeBox($y,$x,$y+$line_cnt+2,$x+$wd,$title);
    for($jj=0;$jj<=$line_cnt;$jj++) {
      C_MoveTo($y+$jj+1,$x+1); print " $msgs[$jj]";
    }
    C_MakeBox($y+$line_cnt+4,$x,$y+$line_cnt+6,$x+$wd,"");
    C_MoveTo($y+$line_cnt+5,$x+1); print $prompt;
    $done = 0; $prom_length = length($prompt);
    while( $done ne "y" && $done ne "yes" ) {
      $in_len = 0;
      while(($in_len < 1) || ($in_len > $limit_len) ) {
        C_MoveTo($y+$line_cnt+5, $x+length($prompt)+1); &C_EraseLine;
        C_MoveTo($y+$line_cnt+5, $x+1); 
        print $prompt . " " x ($wd - $prom_length - 1) . "|";
        C_MoveTo($y+$line_cnt+5, $x+length($prompt)+1);
        $input = <>; chop($input); $in_len = length($input);
      }
      $msgout = "You entered:\'" . $input . "\', Confirm (Y <RETURN> or N)? ";
      C_MoveTo($y+$line_cnt+7,$x); &C_EraseLine;
      C_MoveTo($y+$line_cnt+7,$x); print $msgout;
      $msglen = length($msgout);
      C_MoveTo($y+$line_cnt+7,$x+$msglen);
      $done = <>; chop($done); $done =~ tr/A-Z/a-z/;
      if(length($done)==0) { $done = 'y'; }
    }
    return $input;
 }

sub  C_InputStudentID {
    local($y,$x,$wd,$title,$limit_len,$prompt,@msgs)=@_;
    local($line_cnt)=$#msgs;
    local($done);
    local($jj,$prom_length);
    local($input,$in_len,$msgout,$msglen,$input_ok);
    
    C_ClearScreen;
    C_MakeBox($y,$x,$y+$line_cnt+2,$x+$wd,$title);
    for($jj=0;$jj<=$line_cnt;$jj++) {
      C_MoveTo($y+$jj+1,$x+1); print " $msgs[$jj]";
    }
    C_MakeBox($y+$line_cnt+4,$x,$y+$line_cnt+6,$x+$wd,"");
    C_MoveTo($y+$line_cnt+5,$x+1); print $prompt;
    $done = 0; $prom_length = length($prompt);
    while( $done ne "y" && $done ne "yes" ) {
      $in_len = 0; $input_ok = 0;
      while( ! $input_ok ) {
        C_MoveTo($y+$line_cnt+5, $x+length($prompt)+1); &C_EraseLine;
        C_MoveTo($y+$line_cnt+5, $x+1); 
        print $prompt . " " x ($wd - $prom_length - 1) . "|";
        C_MoveTo($y+$line_cnt+5, $x+length($prompt)+1);
        $input = <>; chop($input); $in_len = length($input);
        if( $in_len <= $limit_len ) { $input_ok = 1; }
      }
      if( $in_len == 0 ) {
        $msgout = "Exit this dialog? Confirm (Y <RETURN> or N)? ";
      } else {
        $msgout = "You entered:\'" . $input . "\', Confirm (Y <RETURN> or N)? ";
      }
      C_MoveTo($y+$line_cnt+7,$x); &C_EraseLine;
      C_MoveTo($y+$line_cnt+7,$x); print $msgout;
      $msglen = length($msgout);
      C_MoveTo($y+$line_cnt+7,$x+$msglen);
      $done = <>; chop($done); $done =~ tr/A-Z/a-z/;
      if(length($done)==0) { $done = 'y'; }
    }
    return $input;
 }



sub  C_InputFromToNum {
    local($y,$x,$wd,$title,$limit_len,$prompt,@msgs)=@_;
    local($line_cnt)=$#msgs;
    local($done);
    local($jj,$prom_length);
    local($input,$in_len,$msgout,$msglen);
    
    C_ClearScreen;
    C_MakeBox($y,$x,$y+$line_cnt+2,$x+$wd,$title);
    for($jj=0;$jj<=$line_cnt;$jj++) {
      C_MoveTo($y+$jj+1,$x+1); print " $msgs[$jj]";
    }
    C_MakeBox($y+$line_cnt+4,$x,$y+$line_cnt+6,$x+$wd,"");
    C_MoveTo($y+$line_cnt+5,$x+1); print $prompt;
    $done = 0; $prom_length = length($prompt);
    while( $done ne "y" && $done ne "yes" ) {
      $in_len = 0;
      while(($in_len < 1) || ($in_len > $limit_len) ) {
        C_MoveTo($y+$line_cnt+5, $x+length($prompt)+1); &C_EraseLine;
        C_MoveTo($y+$line_cnt+5, $x+1); 
        print $prompt . " " x ($wd - $prom_length - 1) . "|";
        C_MoveTo($y+$line_cnt+5, $x+length($prompt)+1);
        $input = <>; chop($input); $in_len = length($input);
      }
      $msgout = "You entered:\'" . $input . "\', Confirm (Y <RETURN> or N)? ";
      C_MoveTo($y+$line_cnt+7,$x); &C_EraseLine;
      C_MoveTo($y+$line_cnt+7,$x); print $msgout;
      $msglen = length($msgout);
      C_MoveTo($y+$line_cnt+7,$x+$msglen);
      $done = <>; chop($done); $done =~ tr/A-Z/a-z/;
      if(length($done)==0) { $done = 'y'; }
    }
    return ($input);
 }



sub  C_Warn {
   local($y,$x,$wd,$title,@items)=@_;
   local($item_cnt)=$#items;
   local($j,$done);
   
   $wd = 25 if( $wd < 25 );
   $done = 'n';
   C_ClearScreen;
   C_MakeBox($y,$x,$y+$item_cnt+5,$x+$wd,$title);
    for ($j=0;$j<=$item_cnt;$j++) {
      C_MoveTo($y+$j+2,$x+1); print " $items[$j]";
    }
   while( $done ne 'y' ) {
     C_MoveTo($y+$item_cnt+4,$x+$wd-25); print "press Return to continue";
     $done = <>; $done = 'y';
   }
   C_ClearScreen;
   return 1;
 }


sub  C_MultilineMsgs {
    local($y,$x,$wd,$title,$prompt,@msgs)=@_;
    local($line_cnt)=$#msgs;
    local($done);
    local($jj);
    local($len);
    
    C_ClearScreen;
    $len = length($prompt);
    C_MakeBox($y,$x,$y+$line_cnt+5,$x+$wd,$title);
    for($jj=0;$jj<=$line_cnt;$jj++) {
      C_MoveTo($y+$jj+2,$x+1); print " $msgs[$jj]";
    }
    C_MoveTo($y+$line_cnt+4,$x+$wd-$len-1); print $prompt;
    $done = <>;
    C_ClearScreen;
 }


sub  C_Pause {
    local($done);
    
    print "Press RETURN to continue"; $done=<>;
 }



1;


