/*
	File:		MiscIPPB.h

	Copyright:	(C) 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __MISCIPPB__
#define __MISCIPPB__

#ifndef __MACTCPCOMMONTYPES__
#include <MacTCPCommonTypes.h>
#endif

#ifndef __APPLETALK__
#include <AppleTalk.h>
#endif

#define ipctlEchoICMP 17			/* send icmp echo */
#define ipctlLAPStats 19			/* get lap stats */

#define IPParamBlockHeader 		\
	struct QElem *qLink; 		\
	short qType; 				\
	short ioTrap; 				\
	Ptr ioCmdAddr; 				\
	ProcPtr ioCompletion; 		\
	OSErr ioResult; 			\
	StringPtr ioNamePtr; 		\
	short ioVRefNum;			\
	short ioCRefNum;			\
	short csCode

typedef void (*ICMPEchoNotifyProcPtr)(struct ICMPParamBlock *iopb);

enum {
	uppICMPEchoNotifyProcInfo = kCStackBased
		 | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(struct ICMPParamBlock*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr ICMPEchoNotifyUPP;

#define CallICMPEchoNotifyProc(userRoutine, iopb)		\
		CallUniversalProc((UniversalProcPtr)userRoutine, uppICMPEchoNotifyProcInfo, iopb)
#define NewICMPEchoNotifyProc(userRoutine)		\
		(ICMPEchoNotifyUPP) NewRoutineDescriptor((ProcPtr)userRoutine, uppICMPEchoNotifyProcInfo, GetCurrentISA())
#else
typedef ICMPEchoNotifyProcPtr ICMPEchoNotifyUPP;

#define CallICMPEchoNotifyProc(userRoutine, iopb)		\
		(*userRoutine)(iopb)
#define NewICMPEchoNotifyProc(userRoutine)		\
		(ICMPEchoNotifyUPP)(userRoutine)
#endif

typedef ICMPEchoNotifyProcPtr ICMPEchoNotifyProc;

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct IPParamBlock {
	IPParamBlockHeader;								/* standard I/O header */
	union {
		struct {
			ip_addr						dest;		/* echo to IP address */
			wdsEntry					data;
			short						timeout;
			Ptr							options;
			unsigned short				optLength;
			ICMPEchoNotifyProc			icmpCompletion;
			unsigned long				userDataPtr;
		} IPEchoPB;
		struct {
			struct LAPStats				*lapStatsPtr;
		} LAPStatsPB;
	} csParam;
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct ICMPParamBlock {
	IPParamBlockHeader;								/* standard I/O header */
	short						params[11];
	struct {
		unsigned long			echoRequestOut;		/* time in ticks of when the echo request went out */
		unsigned long			echoReplyIn;		/* time in ticks of when the reply was received */
		struct rdsEntry			echoedData;			/* data received in responce */
		Ptr						options;
		unsigned long			userDataPtr;
	} icmpEchoInfo;
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct LAPStats {
	short						ifType;
	char						*ifString;
	short						ifMaxMTU;
	long						ifSpeed;
	short						ifPhyAddrLength;
	char						*ifPhysicalAddress;
	union {
		struct arp_entry			*arp_table;
		struct nbp_entry			*nbp_table;
	} AddrXlation;
	short						slotNumber;
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

typedef struct LAPStats LAPStats;

#define NBP_TABLE_SIZE 20

#define NBP_MAX_NAME_SIZE 16+10+2

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct nbp_entry {
	ip_addr						ip_address;		/* IP address */
	AddrBlock					at_address;		/* matching AppleTalk address */
	Boolean						gateway;		/* TRUE if entry for a gateway */
	Boolean						valid;			/* TRUE if LAP address is valid */
	Boolean						probing;		/* TRUE if NBP lookup pending */
	long						age;			/* ticks since cache entry verified */
	long						access;			/* ticks since last access */
	char						filler[116];	/* for internal use only !!! */
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

#define ARP_TABLE_SIZE 20						/* number of ARP table entries */

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct Enet_addr {
	b_16						en_hi;
	b_32						en_lo;
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

typedef struct Enet_addr Enet_addr;

#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif
struct arp_entry {
	short						age;			/* cache aging field */
	b_16						protocol;		/* Protocol type */
	ip_addr						ip_address;		/* IP address */
	Enet_addr					en_address;		/* matching Ethernet address */
};
#if defined(powerc) || defined(__powerc)
#pragma options align=reset
#endif

typedef struct arp_entry arp_entry;

#endif

