/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jibri;

import org.jitsi.utils.StringUtils;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;

public class JibriBusyStatusPacketExt
extends AbstractPacketExtension {
    public static final String NAMESPACE = "http://jitsi.org/protocol/jibri";
    public static final String ELEMENT_NAME = "busy-status";
    private static final String STATUS_ATTRIBUTE = "status";

    public JibriBusyStatusPacketExt() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public static void registerExtensionProvider() {
        ProviderManager.addExtensionProvider((String)ELEMENT_NAME, (String)NAMESPACE, new DefaultPacketExtensionProvider<JibriBusyStatusPacketExt>(JibriBusyStatusPacketExt.class));
    }

    public BusyStatus getStatus() {
        return BusyStatus.parse(this.getAttributeAsString(STATUS_ATTRIBUTE));
    }

    public void setStatus(BusyStatus status) {
        this.setAttribute(STATUS_ATTRIBUTE, (Object)status);
    }

    public static enum BusyStatus {
        IDLE("idle"),
        BUSY("busy"),
        UNDEFINED("undefined");

        private String name;

        private BusyStatus(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static BusyStatus parse(String status) {
            if (StringUtils.isNullOrEmpty((String)status)) {
                return UNDEFINED;
            }
            try {
                return BusyStatus.valueOf(status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }
}

