/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteOrder;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.util.MediaThread;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.jmfext.media.renderer.AbstractRenderer;
import org.jitsi.service.neomedia.VolumeControl;

public abstract class AbstractAudioRenderer<T extends AudioSystem>
extends AbstractRenderer<AudioFormat> {
    public static final int JAVA_AUDIO_FORMAT_ENDIAN = 1;
    public static final int NATIVE_AUDIO_FORMAT_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? 1 : 0;
    protected final T audioSystem;
    protected final AudioSystem.DataFlow dataFlow;
    private GainControl gainControl;
    private MediaLocator locator;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            AbstractAudioRenderer.this.propertyChange(ev);
        }
    };
    private VolumeControl volumeControl;

    protected AbstractAudioRenderer(T audioSystem) {
        this(audioSystem, AudioSystem.DataFlow.PLAYBACK);
    }

    protected AbstractAudioRenderer(T audioSystem, AudioSystem.DataFlow dataFlow) {
        MediaServiceImpl mediaServiceImpl;
        if (dataFlow != AudioSystem.DataFlow.NOTIFY && dataFlow != AudioSystem.DataFlow.PLAYBACK) {
            throw new IllegalArgumentException("dataFlow");
        }
        this.audioSystem = audioSystem;
        this.dataFlow = dataFlow;
        this.gainControl = AudioSystem.DataFlow.PLAYBACK.equals((Object)dataFlow) ? ((mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl()) == null ? null : (GainControl)mediaServiceImpl.getOutputVolumeControl()) : null;
    }

    protected AbstractAudioRenderer(String locatorProtocol) {
        this(locatorProtocol, AudioSystem.DataFlow.PLAYBACK);
    }

    protected AbstractAudioRenderer(String locatorProtocol, AudioSystem.DataFlow dataFlow) {
        this(AudioSystem.getAudioSystem(locatorProtocol), dataFlow);
    }

    public void close() {
        if (this.audioSystem != null) {
            this.audioSystem.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public Object[] getControls() {
        Object[] objectArray;
        GainControl gainControl = this.getGainControl();
        if (gainControl == null) {
            objectArray = super.getControls();
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = gainControl;
        }
        return objectArray;
    }

    protected GainControl getGainControl() {
        VolumeControl volumeControl = this.volumeControl;
        GainControl gainControl = this.gainControl;
        if (volumeControl instanceof GainControl) {
            gainControl = (GainControl)volumeControl;
        }
        return gainControl;
    }

    public MediaLocator getLocator() {
        CaptureDeviceInfo2 device;
        MediaLocator locator = this.locator;
        if (locator == null && this.audioSystem != null && (device = ((AudioSystem)((Object)this.audioSystem)).getSelectedDevice(this.dataFlow)) != null) {
            locator = device.getLocator();
        }
        return locator;
    }

    public Format[] getSupportedInputFormats() {
        return ((AudioSystem)((Object)this.audioSystem)).getDevice(this.dataFlow, this.getLocator()).getFormats();
    }

    public void open() throws ResourceUnavailableException {
        if (this.locator == null && this.audioSystem != null) {
            this.audioSystem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void playbackDevicePropertyChange(PropertyChangeEvent ev) {
    }

    private void propertyChange(PropertyChangeEvent ev) {
        String propertyName;
        switch (this.dataFlow) {
            case NOTIFY: {
                propertyName = "notifyDevice";
                break;
            }
            case PLAYBACK: {
                propertyName = "playbackDevice";
                break;
            }
            default: {
                return;
            }
        }
        if (propertyName.equals(ev.getPropertyName())) {
            this.playbackDevicePropertyChange(ev);
        }
    }

    public void setLocator(MediaLocator locator) {
        if (this.locator == null ? locator == null : this.locator.equals((Object)locator)) {
            return;
        }
        this.locator = locator;
    }

    public void setVolumeControl(VolumeControl volumeControl) {
        this.volumeControl = volumeControl;
    }

    public static void useAudioThreadPriority() {
        AbstractAudioRenderer.useThreadPriority(MediaThread.getAudioPriority());
    }
}

