/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile.DataSource;
import org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile.RawPacketScheduler;
import org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile.RtpdumpFileReader;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.logging.Logger;

public class RtpdumpStream
extends AbstractVideoPullBufferStream<DataSource> {
    private static final Logger logger = Logger.getLogger(RtpdumpStream.class);
    private final RawPacketScheduler rawPacketScheduler;
    private boolean lastReadWasMarked = true;
    private RtpdumpFileReader rtpFileReader;
    private long timestamp;

    RtpdumpStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
        long clockRate;
        Format format = this.getFormat();
        if (format instanceof AudioFormat) {
            clockRate = (long)((AudioFormat)format).getSampleRate();
        } else if (format instanceof VideoFormat) {
            clockRate = (long)((VideoFormat)format).getFrameRate();
        } else {
            logger.warn((Object)"Unknown format. Creating RtpdumpStream with clockrate 1 000 000 000.");
            clockRate = 1000000000L;
        }
        this.rawPacketScheduler = new RawPacketScheduler(clockRate);
        String rtpdumpFilePath = dataSource.getLocator().getRemainder();
        this.rtpFileReader = new RtpdumpFileReader(rtpdumpFilePath);
    }

    @Override
    protected void doRead(Buffer buffer) throws IOException {
        Format format = buffer.getFormat();
        if (format == null && (format = this.getFormat()) != null) {
            buffer.setFormat(format);
        }
        RawPacket rtpPacket = this.rtpFileReader.getNextPacket(true);
        byte[] data = rtpPacket.getPayload();
        buffer.setData((Object)data);
        buffer.setOffset(rtpPacket.getOffset());
        buffer.setLength(rtpPacket.getPayloadLength());
        buffer.setFlags(32896);
        if (this.lastReadWasMarked) {
            this.timestamp = System.nanoTime();
        }
        this.lastReadWasMarked = rtpPacket.isPacketMarked();
        if (this.lastReadWasMarked) {
            buffer.setFlags(buffer.getFlags() | 0x800);
        }
        buffer.setTimeStamp(this.timestamp);
        try {
            this.rawPacketScheduler.schedule(rtpPacket);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

