/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.launchutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.launchutils.DeleteOnHaltHook;
import net.java.sip.communicator.util.launchutils.LaunchArgHandler;

public class SipCommunicatorLock
extends Thread {
    private static final Logger logger = Logger.getLogger(SipCommunicatorLock.class);
    public static final int LOCK_ERROR = 300;
    public static final int SUCCESS = 0;
    public static final int ALREADY_STARTED = 301;
    private static final String LOCK_FILE_NAME = ".lock";
    private static final String PNAME_LOCK_ADDRESS = "lockAddress";
    private static final String PNAME_LOCK_PORT = "lockPort";
    private static final String ARGUMENT = "Argument";
    private static final String ARG_COUNT = "Arg-Count";
    private static final String ERROR_ARG = "ERROR";
    private static final String CRLF = "\r\n";
    private long LOCK_COMMUNICATION_DELAY = 1000L;
    private ServerSocket instanceServerSocket = null;
    private static final int LOCK_FILE_READ_RETRY = 8;
    private static final long LOCK_FILE_READ_WAIT = 500L;
    private static final String WEIRD_MACOSX_LOOPBACK_ADDRESS = "fe80:0:0:0:0:0:0:1";

    public int tryLock(String[] args) {
        File lockFile = this.getLockFile();
        if (lockFile.exists()) {
            InetSocketAddress lockAddress = this.readLockFileRetrying(lockFile);
            if (lockAddress != null && this.interInstanceConnect(lockAddress, args) == 0) {
                return 301;
            }
            lockFile.delete();
        }
        return this.lock(lockFile);
    }

    private int lock(File lockFile) {
        InetSocketAddress serverSocketAddress;
        InetAddress lockAddress = this.getRandomBindAddress();
        if (lockAddress == null) {
            return 300;
        }
        int port = this.getRandomPortNumber();
        for (int retries = 7; this.startLockServer(serverSocketAddress = new InetSocketAddress(lockAddress, port)) != 0 && retries > 0; --retries) {
            port = this.getRandomPortNumber();
        }
        try {
            lockFile.getParentFile().mkdirs();
            lockFile.createNewFile();
        }
        catch (IOException e) {
            logger.error("Failed to create lock file" + lockFile, e);
        }
        lockFile.deleteOnExit();
        DeleteOnHaltHook.add(lockFile.getAbsolutePath());
        this.writeLockFile(lockFile, serverSocketAddress);
        return 0;
    }

    private int startLockServer(InetSocketAddress localAddress) {
        try {
            this.instanceServerSocket = new ServerSocket();
        }
        catch (IOException exc) {
            logger.error("Couldn't create server socket", exc);
            return 300;
        }
        try {
            this.instanceServerSocket.bind(localAddress, 16);
        }
        catch (IOException exc) {
            logger.error("Couldn't create server socket", exc);
            return 300;
        }
        LockServer lockServ = new LockServer(this.instanceServerSocket);
        lockServ.start();
        return 0;
    }

    private InetAddress getRandomBindAddress() {
        NetworkInterface loopback;
        try {
            Enumeration<NetworkInterface> interfaces;
            try {
                interfaces = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException exc) {
                logger.error("Failed to obtain a list of the local interfaces.", exc);
                return null;
            }
            loopback = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (!this.isLoopbackInterface(iface)) continue;
                loopback = iface;
                break;
            }
            if (loopback == null) {
                loopback = NetworkInterface.getNetworkInterfaces().nextElement();
            }
        }
        catch (SocketException exc) {
            logger.error("Could not find the loopback interface", exc);
            return null;
        }
        InetAddress addr = loopback.getInetAddresses().nextElement();
        return addr;
    }

    private int getRandomPortNumber() {
        return (int)(Math.random() * 64509.0) + 1025;
    }

    private InetSocketAddress readLockFileRetrying(File lockFile) {
        InetSocketAddress res = null;
        for (int retries = 8; res == null && retries > 0; --retries) {
            res = this.readLockFile(lockFile);
            if (res != null) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return res;
    }

    private InetSocketAddress readLockFile(File lockFile) {
        int port;
        Properties lockProperties = new Properties();
        try {
            lockProperties.load(new FileInputStream(lockFile));
        }
        catch (Exception exc) {
            logger.error("Failed to read lock properties.", exc);
            return null;
        }
        String lockAddressStr = lockProperties.getProperty(PNAME_LOCK_ADDRESS);
        if (lockAddressStr == null) {
            logger.error("Lock file contains no lock address.");
            return null;
        }
        String lockPort = lockProperties.getProperty(PNAME_LOCK_PORT);
        if (lockPort == null) {
            logger.error("Lock file contains no lock port.");
            return null;
        }
        InetAddress lockAddress = this.findLocalAddress(lockAddressStr);
        if (lockAddress == null) {
            logger.error(lockAddressStr + " is not a valid local address.");
            return null;
        }
        try {
            port = Integer.parseInt(lockPort);
        }
        catch (NumberFormatException exc) {
            logger.error(lockPort + " is not a valid port number.", exc);
            return null;
        }
        InetSocketAddress lockSocketAddress = new InetSocketAddress(lockAddress, port);
        return lockSocketAddress;
    }

    private int writeLockFile(File lockFile, InetSocketAddress lockAddress) {
        Properties lockProperties = new Properties();
        lockProperties.setProperty(PNAME_LOCK_ADDRESS, lockAddress.getAddress().getHostAddress());
        lockProperties.setProperty(PNAME_LOCK_PORT, Integer.toString(lockAddress.getPort()));
        try {
            lockProperties.store(new FileOutputStream(lockFile), "Jitsi lock file. This file will be automatically removed when execution of Jitsi terminates.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error("Failed to create lock file.", e);
            return 300;
        }
        return 0;
    }

    private File getLockFile() {
        String homeDirLocation = System.getProperty("net.java.sip.communicator.SC_CACHE_DIR_LOCATION");
        String homeDirName = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
        return new File(new File(homeDirLocation, homeDirName), LOCK_FILE_NAME);
    }

    private InetAddress findLocalAddress(String addressStr) {
        Enumeration<NetworkInterface> ifaces;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException exc) {
            logger.error("Could not extract the list of local intefcaces.", exc);
            return null;
        }
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> addreses = iface.getInetAddresses();
            while (addreses.hasMoreElements()) {
                InetAddress addr = addreses.nextElement();
                if (!addr.getHostAddress().equals(addressStr)) continue;
                return addr;
            }
        }
        return null;
    }

    private int interInstanceConnect(InetSocketAddress sockAddr, String[] args) {
        try {
            Socket interInstanceSocket = new Socket(sockAddr.getAddress(), sockAddr.getPort());
            LockClient lockClient = new LockClient(interInstanceSocket);
            lockClient.start();
            PrintStream printStream = new PrintStream(interInstanceSocket.getOutputStream());
            printStream.print("Arg-Count=" + args.length + CRLF);
            for (int i = 0; i < args.length; ++i) {
                printStream.print("Argument=" + args[i] + CRLF);
            }
            lockClient.waitForReply(this.LOCK_COMMUNICATION_DELAY);
            String serverReadArgCountStr = lockClient.message.substring("Arg-Count=".length());
            int serverReadArgCount = Integer.parseInt(serverReadArgCountStr);
            if (logger.isDebugEnabled()) {
                logger.debug("Server read " + serverReadArgCount + " args.");
            }
            if (serverReadArgCount != args.length) {
                return 300;
            }
            printStream.flush();
            printStream.close();
            interInstanceSocket.close();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to connect to a running sc instance.");
            }
            return 300;
        }
        return 0;
    }

    private boolean isLoopbackInterface(NetworkInterface iface) {
        try {
            Method method = iface.getClass().getMethod("isLoopback", new Class[0]);
            return (Boolean)method.invoke((Object)iface, new Object[0]);
        }
        catch (Throwable method) {
            InetAddress address;
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            return addresses.hasMoreElements() && ((address = addresses.nextElement()).isLoopbackAddress() || address.getHostAddress().startsWith(WEIRD_MACOSX_LOOPBACK_ADDRESS));
        }
    }

    private static class LockServerConnectionProcessor
    extends Thread {
        private final Socket connectionSocket;

        public LockServerConnectionProcessor(Socket connectionSocket) {
            this.connectionSocket = connectionSocket;
        }

        @Override
        public void run() {
            PrintWriter printer;
            InputStream is;
            try {
                is = this.connectionSocket.getInputStream();
                printer = new PrintWriter(this.connectionSocket.getOutputStream());
            }
            catch (IOException exc) {
                logger.warn("Failed to read arguments from another SC instance", exc);
                return;
            }
            ArrayList<String> argsList = new ArrayList<String>();
            if (logger.isDebugEnabled()) {
                logger.debug("Handling incoming connection");
            }
            int argCount = 1024;
            try {
                BufferedReader lineReader = new BufferedReader(new InputStreamReader(is));
                do {
                    String line = lineReader.readLine();
                    if (logger.isDebugEnabled()) {
                        logger.debug(line);
                    }
                    if (line.startsWith(SipCommunicatorLock.ARG_COUNT)) {
                        argCount = Integer.parseInt(line.substring("Arg-Count=".length()));
                        continue;
                    }
                    if (!line.startsWith(SipCommunicatorLock.ARGUMENT)) continue;
                    String arg = line.substring("Argument=".length());
                    argsList.add(arg);
                } while (argCount > argsList.size());
                printer.print("Arg-Count=" + argCount + SipCommunicatorLock.CRLF);
                printer.close();
                this.connectionSocket.close();
                String[] args = new String[argsList.size()];
                LaunchArgHandler.getInstance().handleConcurrentInvocationRequestArgs(argsList.toArray(args));
            }
            catch (IOException exc) {
                if (logger.isInfoEnabled()) {
                    logger.info("An IOException is thrown while processing remote args", exc);
                }
                printer.print("ERROR=" + exc.getMessage());
            }
        }
    }

    private static class LockServer
    extends Thread {
        private boolean keepAccepting = true;
        private final ServerSocket lockSocket;

        public LockServer(ServerSocket serverSocket) {
            super(LockServer.class.getName());
            this.setDaemon(true);
            this.lockSocket = serverSocket;
        }

        @Override
        public void run() {
            try {
                while (this.keepAccepting) {
                    Socket instanceSocket = this.lockSocket.accept();
                    new LockServerConnectionProcessor(instanceSocket).start();
                }
            }
            catch (Exception exc) {
                logger.warn("Someone tried ", exc);
            }
        }
    }

    private static class LockClient
    extends Thread {
        public String message = null;
        private final Socket interInstanceSocket;

        public LockClient(Socket commSocket) {
            super(LockClient.class.getName());
            this.setDaemon(true);
            this.interInstanceSocket = commSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForReply(long runDuration) {
            try {
                LockClient lockClient = this;
                synchronized (lockClient) {
                    if (this.message != null) {
                        return;
                    }
                    this.wait(runDuration);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Done waiting. Will close socket");
                }
                this.interInstanceSocket.close();
            }
            catch (Exception exception) {
                logger.error("Failed to close our inter instance input stream", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    BufferedReader lineReader = new BufferedReader(new InputStreamReader(this.interInstanceSocket.getInputStream()));
                    this.message = lineReader.readLine();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Message is " + this.message);
                    }
                    LockClient lockClient = this;
                    synchronized (lockClient) {
                        this.notifyAll();
                    }
                }
                catch (IOException exc) {
                    if (!logger.isInfoEnabled()) break block6;
                    logger.info("An IOException is thrown while reading sock", exc);
                }
            }
        }
    }
}

