/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceUtils {
    public static <T> T getService(BundleContext bundleContext, Class<T> serviceClass) {
        ServiceReference serviceReference = bundleContext == null ? null : bundleContext.getServiceReference(serviceClass);
        return (T)(serviceReference == null ? null : bundleContext.getService(serviceReference));
    }

    public static <T> Collection<ServiceReference<T>> getServiceReferences(BundleContext bundleContext, Class<T> serviceClass) {
        List<ServiceReference<T>> serviceReferences;
        try {
            serviceReferences = bundleContext.getServiceReferences(serviceClass, null);
        }
        catch (InvalidSyntaxException ex) {
            serviceReferences = null;
        }
        if (serviceReferences == null) {
            serviceReferences = Collections.emptyList();
        }
        return serviceReferences;
    }

    private ServiceUtils() {
    }
}

