/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.extensions.system;

import io.kotlintest.Description;
import io.kotlintest.Spec;
import io.kotlintest.TestCase;
import io.kotlintest.TestResult;
import io.kotlintest.extensions.TestListener;
import io.kotlintest.extensions.TopLevelTest;
import io.kotlintest.extensions.system.OverrideMode;
import io.kotlintest.extensions.system.SystemEnvironmentExtensionsKt;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0004J\b\u0010\f\u001a\u00020\u000bH\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/kotlintest/extensions/system/SystemEnvironmentListener;", "Lio/kotlintest/extensions/TestListener;", "environment", "", "", "mode", "Lio/kotlintest/extensions/system/OverrideMode;", "(Ljava/util/Map;Lio/kotlintest/extensions/system/OverrideMode;)V", "originalEnvironment", "kotlin.jvm.PlatformType", "changeSystemEnvironment", "", "resetSystemEnvironment", "kotlintest-extensions"})
public abstract class SystemEnvironmentListener
implements TestListener {
    private final Map<String, String> originalEnvironment;
    private final Map<String, String> environment;
    private final OverrideMode mode;

    protected final void changeSystemEnvironment() {
        SystemEnvironmentExtensionsKt.setEnvironmentMap(this.mode.override(this.originalEnvironment, this.environment));
    }

    protected final void resetSystemEnvironment() {
        SystemEnvironmentExtensionsKt.setEnvironmentMap(this.originalEnvironment);
    }

    public SystemEnvironmentListener(@NotNull Map<String, String> environment, @NotNull OverrideMode mode) {
        Intrinsics.checkParameterIsNotNull(environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        this.environment = environment;
        this.mode = mode;
        Map<String, String> map = System.getenv();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"System.getenv()");
        this.originalEnvironment = MapsKt.toMap(map);
    }

    public void afterDiscovery(@NotNull List<Description> descriptions) {
        Intrinsics.checkParameterIsNotNull(descriptions, (String)"descriptions");
        TestListener.DefaultImpls.afterDiscovery((TestListener)this, descriptions);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="ProjectListener"), message="Prefer using ProjectListeners over TestListener for project before/after")
    public void afterProject() {
        TestListener.DefaultImpls.afterProject((TestListener)this);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="afterSpec(Spec)"), message="use afterSpec(Spec)")
    public void afterSpec(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.afterSpec((TestListener)this, (Description)description, (Spec)spec);
    }

    public void afterSpec(@NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.afterSpec((TestListener)this, (Spec)spec);
    }

    public void afterSpecClass(@NotNull Spec spec, @NotNull Map<TestCase, TestResult> results) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        TestListener.DefaultImpls.afterSpecClass((TestListener)this, (Spec)spec, results);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="afterSpecClass(Spec, Map<TestCase, TestResult>)"), message="use afterSpecClass(Spec, Map<TestCase, TestResult>) which provides the full test case instance")
    public void afterSpecCompleted(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.afterSpecCompleted((TestListener)this, (Description)description, (Spec)spec);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="afterTest(TestCase)"), message="use afterTest(TestCase) which provides the full test case instance")
    public void afterTest(@NotNull Description description, @NotNull TestResult result) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        TestListener.DefaultImpls.afterTest((TestListener)this, (Description)description, (TestResult)result);
    }

    public void afterTest(@NotNull TestCase testCase, @NotNull TestResult result) {
        Intrinsics.checkParameterIsNotNull((Object)testCase, (String)"testCase");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        TestListener.DefaultImpls.afterTest((TestListener)this, (TestCase)testCase, (TestResult)result);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="ProjectListener"), message="Prefer using ProjectListeners over TestListener for project before/after")
    public void beforeProject() {
        TestListener.DefaultImpls.beforeProject((TestListener)this);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="beforeSpec(Spec)"), message="use beforeSpec(Spec)")
    public void beforeSpec(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.beforeSpec((TestListener)this, (Description)description, (Spec)spec);
    }

    public void beforeSpec(@NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.beforeSpec((TestListener)this, (Spec)spec);
    }

    public void beforeSpecClass(@NotNull Spec spec, @NotNull List<TopLevelTest> tests) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Intrinsics.checkParameterIsNotNull(tests, (String)"tests");
        TestListener.DefaultImpls.beforeSpecClass((TestListener)this, (Spec)spec, tests);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="beforeSpecClass(Spec)"), message="use beforeSpecClass(Spec, List<TopLevelTest>)")
    public void beforeSpecStarted(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.beforeSpecStarted((TestListener)this, (Description)description, (Spec)spec);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="beforeTest(TestCase)"), message="use beforeTest(TestCase) which provides the full test case instance")
    public void beforeTest(@NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        TestListener.DefaultImpls.beforeTest((TestListener)this, (Description)description);
    }

    public void beforeTest(@NotNull TestCase testCase) {
        Intrinsics.checkParameterIsNotNull((Object)testCase, (String)"testCase");
        TestListener.DefaultImpls.beforeTest((TestListener)this, (TestCase)testCase);
    }
}

