/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.utility.LoggerSingleton;

public class InputStreamPushSourceStream
implements PushSourceStream {
    private static final Logger logger = LoggerSingleton.logger;
    private final ContentDescriptor outputContentDescriptor;
    private final InputStream is;
    private boolean eos;
    private SourceTransferHandler transferHandler;

    public InputStreamPushSourceStream(ContentDescriptor outputContentDescriptor, InputStream is) {
        this.outputContentDescriptor = outputContentDescriptor;
        this.is = is;
    }

    @Override
    public boolean endOfStream() {
        logger.finer(this.getClass().getSimpleName() + " endOfStream");
        return this.eos;
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        logger.finer(this.getClass().getSimpleName() + " getContentDescriptor");
        return this.outputContentDescriptor;
    }

    @Override
    public long getContentLength() {
        logger.finer(this.getClass().getSimpleName() + " getContentLength");
        return 0L;
    }

    @Override
    public Object getControl(String controlType) {
        logger.finer(this.getClass().getSimpleName() + " getControl");
        return null;
    }

    @Override
    public Object[] getControls() {
        logger.finer(this.getClass().getSimpleName() + " getControls");
        return new Object[0];
    }

    @Override
    public int getMinimumTransferSize() {
        logger.finer(this.getClass().getSimpleName() + " getMinimumTransferSize");
        return 0;
    }

    public SourceTransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    public void notifyDataAvailable() {
        if (this.transferHandler != null) {
            this.transferHandler.transferData(this);
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result = this.is.read(buffer, offset, length);
        if (result < 0) {
            this.eos = true;
        }
        return result;
    }

    @Override
    public void setTransferHandler(SourceTransferHandler transferHandler) {
        logger.finer(this.getClass().getSimpleName() + " setTransferHandler");
        this.transferHandler = transferHandler;
    }
}

