/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirAbstractElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirReference;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirWhenSubject;
import org.jetbrains.kotlin.fir.declarations.impl.FirVariableImpl;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractAnnotatedElement;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractCall;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirArraySetCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirComponentCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImplKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.expressions.impl.FirErrorExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirModifiableQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.impl.FirOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirQualifiedAccessExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirStringConcatenationCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirTypeOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirVariableAssignmentImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenBranchImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenSubjectExpressionImpl;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirExplicitThisReference;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReferenceImpl;
import org.jetbrains.kotlin.fir.references.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImpl;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.resolve.constants.evaluate.ParseUtilsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u00e6\u0001\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001ab\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u001d\u0010\u0018\u001a\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u0019\u00a2\u0006\u0002\b\u001d2\u0019\u0010\u001e\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\u001dH\u0000\u001aK\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u00172\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\u0002\b\u001dH\u0000\u001a\"\u0010*\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020\u0015H\u0000\u001a*\u0010,\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u000eH\u0000\u001a*\u0010,\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u000eH\u0000\u001a\u0017\u0010/\u001a\u0004\u0018\u00010\u00012\u0006\u00100\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\u00101\u001aI\u00102\u001a\u000203*\u0004\u0018\u00010&2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u0002062\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\u0002\b\u001dH\u0000\u001a6\u00107\u001a\u000208*\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\u00172\b\u0010:\u001a\u0004\u0018\u00010&2\u0006\u0010;\u001a\u00020<H\u0000\u001a,\u0010=\u001a\u00020>*\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u00172\u0006\u0010A\u001a\u00020BH\u0000\u001a,\u0010C\u001a\u00020>*\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u00032\u0006\u0010A\u001a\u00020BH\u0000\u001a9\u0010E\u001a\u00020F*\u00020G2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010H\u001a\u0004\u0018\u00010&2\u0019\u0010I\u001a\u0015\u0012\u0004\u0012\u00020J\u0012\u0006\u0012\u0004\u0018\u00010K0\u001f\u00a2\u0006\u0002\b\u001dH\u0002\u001a\u0013\u0010L\u001a\u0004\u0018\u00010\u0001*\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u000e\u0010M\u001a\u0004\u0018\u00010\f*\u00020NH\u0000\u001a\f\u0010O\u001a\u000206*\u00020NH\u0000\u001ak\u0010P\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020R0Q2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010A\u001a\u00020B2\u0006\u0010S\u001a\u00020T2\u001f\u0010)\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u0019\u00a2\u0006\u0002\b\u001d2\u0019\u0010U\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\u001dH\u0000\u00a2\u0006\u0002\u0010V\u001aX\u0010P\u001a\u00020\u000e*\u00020R2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010S\u001a\u00020T2\u001f\u0010)\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u0019\u00a2\u0006\u0002\b\u001d2\u0019\u0010U\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\u001dH\u0000\u001aH\u0010W\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020X0Q2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010:\u001a\u00020Y2\u001f\u0010)\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u0019\u00a2\u0006\u0002\b\u001dH\u0000\u00a2\u0006\u0002\u0010Z\u001a\u000e\u0010[\u001a\u0004\u0018\u00010\f*\u00020NH\u0000\u00a8\u0006\\"}, d2={"escapedStringToCharacter", "", "text", "", "(Ljava/lang/String;)Ljava/lang/Character;", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "psi", "Lcom/intellij/psi/PsiElement;", "name", "Lorg/jetbrains/kotlin/name/Name;", "generateConstantExpressionByLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "generateDestructuringBlock", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/expressions/FirVariable;", "tmpVariable", "", "extractAnnotationsTo", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirAbstractAnnotatedElement;", "", "Lkotlin/ExtensionFunctionType;", "toFirOrImplicitTypeRef", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "generateIncrementOrDecrementBlock", "baseExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "callName", "prefix", "convert", "generateResolvedAccessExpression", "variable", "generateTemporaryVariable", "specialName", "initializer", "translateEscape", "c", "(C)Ljava/lang/Character;", "generateAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "value", "operation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "generateContainsOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "inverted", "base", "operationReference", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "other", "isAnd", "basePsi", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateNotNullOrOther", "caseId", "initializeLValue", "Lorg/jetbrains/kotlin/fir/FirReference;", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirModifiableQualifiedAccess;", "left", "convertQualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "parseCharacter", "toBinaryName", "Lcom/intellij/psi/tree/IElementType;", "toFirOperation", "toFirWhenCondition", "", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "subject", "Lorg/jetbrains/kotlin/fir/FirWhenSubject;", "toFirOrErrorTypeRef", "([Lorg/jetbrains/kotlin/psi/KtWhenCondition;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/fir/FirWhenSubject;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toInterpolatingCall", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "([Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toUnaryName", "psi2fir"})
public final class ConversionUtilsKt {
    @Nullable
    public static final Character parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkParameterIsNotNull((Object)$this$parseCharacter, (String)"$this$parseCharacter");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return null;
        }
        CharSequence charSequence = $this$parseCharacter;
        int n = 1;
        int n2 = $this$parseCharacter.length() - 1;
        boolean bl = false;
        String string = ((String)charSequence).substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String text2 = string;
        charSequence = text2;
        n = 0;
        if (charSequence.length() == 0) {
            return null;
        }
        return text2.charAt(0) != '\\' ? (text2.length() == 1 ? Character.valueOf(text2.charAt(0)) : null) : ConversionUtilsKt.escapedStringToCharacter(text2);
    }

    @Nullable
    public static final Character escapedStringToCharacter(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0 && text2.charAt(0) == '\\';
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string = "Only escaped sequences must be passed to this routine: " + text2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = text2;
        int n = 1;
        int n2 = 0;
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String escape = string2;
        switch (escape.length()) {
            case 0: {
                return null;
            }
            case 1: {
                Character c = ConversionUtilsKt.translateEscape(escape.charAt(0));
                if (c == null) {
                    return null;
                }
                return Character.valueOf(c.charValue());
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    String string3 = escape;
                    n2 = 1;
                    boolean bl4 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    Integer intValue = Integer.valueOf(string5, 16);
                    return Character.valueOf((char)intValue.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    public static final Character translateEscape(char c) {
        Character c2;
        switch (c) {
            case 't': {
                c2 = Character.valueOf('\t');
                break;
            }
            case 'b': {
                c2 = Character.valueOf('\b');
                break;
            }
            case 'n': {
                c2 = Character.valueOf('\n');
                break;
            }
            case 'r': {
                c2 = Character.valueOf('\r');
                break;
            }
            case '\'': {
                c2 = Character.valueOf('\'');
                break;
            }
            case '\"': {
                c2 = Character.valueOf('\"');
                break;
            }
            case '\\': {
                c2 = Character.valueOf('\\');
                break;
            }
            case '$': {
                c2 = Character.valueOf('$');
                break;
            }
            default: {
                c2 = null;
            }
        }
        return c2;
    }

    @NotNull
    public static final FirExpression generateConstantExpressionByLiteral(@NotNull FirSession session, @NotNull KtConstantExpression expression2) {
        FirAbstractExpression firAbstractExpression;
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        ASTNode aSTNode = expression2.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"expression.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.node.elementType");
        IElementType type2 = iElementType;
        String string = expression2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.text");
        String text2 = string;
        IElementType iElementType2 = type2;
        Serializable convertedText = Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FLOAT_CONSTANT) ? (Serializable)ParseUtilsKt.parseNumericLiteral(text2, type2) : (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.BOOLEAN_CONSTANT) ? (Serializable)Boolean.valueOf(ParseUtilsKt.parseBoolean(text2)) : null);
        iElementType2 = type2;
        if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            firAbstractExpression = convertedText instanceof Long && (ParseUtilsKt.hasLongSuffix(text2) || ParseUtilsKt.hasUnsignedLongSuffix(text2) || ParseUtilsKt.hasUnsignedSuffix(text2) || ((Number)convertedText).longValue() > (long)Integer.MAX_VALUE || ((Number)convertedText).longValue() < (long)Integer.MIN_VALUE) ? FirConstExpressionImplKt.FirConstExpressionImpl(session, expression2, IrConstKind.Long.INSTANCE, convertedText, "Incorrect long: " + text2) : (convertedText instanceof Number ? FirConstExpressionImplKt.FirConstExpressionImpl(session, expression2, IrConstKind.Int.INSTANCE, ((Number)convertedText).intValue(), "Incorrect int: " + text2) : (FirAbstractExpression)new FirErrorExpressionImpl(session, expression2, "Incorrect constant expression: " + text2));
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
            if (convertedText instanceof Float) {
                firAbstractExpression = FirConstExpressionImplKt.FirConstExpressionImpl(session, expression2, IrConstKind.Float.INSTANCE, convertedText, "Incorrect float: " + text2);
            } else {
                Serializable serializable = convertedText;
                if (serializable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                }
                firAbstractExpression = FirConstExpressionImplKt.FirConstExpressionImpl(session, expression2, IrConstKind.Double.INSTANCE, (Double)serializable, "Incorrect double: " + text2);
            }
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
            firAbstractExpression = FirConstExpressionImplKt.FirConstExpressionImpl(session, expression2, IrConstKind.Char.INSTANCE, ConversionUtilsKt.parseCharacter(text2), "Incorrect character: " + text2);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
            Serializable serializable = convertedText;
            if (serializable == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            firAbstractExpression = new FirConstExpressionImpl<Boolean>(session, expression2, IrConstKind.Boolean.INSTANCE, (Boolean)serializable);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.NULL)) {
            firAbstractExpression = new FirConstExpressionImpl<Object>(session, expression2, IrConstKind.Null.INSTANCE, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unknown literal type: " + type2 + ", " + text2)));
        }
        return firAbstractExpression;
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toBinaryName, (String)"$this$toBinaryName");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkExpressionValueIsNotNull(immutableBiMap, (String)"OperatorConventions.BINARY_OPERATION_NAMES");
        Map map2 = immutableBiMap;
        boolean bl = false;
        return (Name)map2.get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toUnaryName, (String)"$this$toUnaryName");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkExpressionValueIsNotNull(immutableBiMap, (String)"OperatorConventions.UNARY_OPERATION_NAMES");
        Map map2 = immutableBiMap;
        boolean bl = false;
        return (Name)map2.get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        FirOperation firOperation;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirOperation, (String)"$this$toFirOperation");
        IElementType iElementType = $this$toFirOperation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            firOperation = FirOperation.EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            firOperation = FirOperation.NOT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ)) {
            firOperation = FirOperation.IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) {
            firOperation = FirOperation.NOT_IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ)) {
            firOperation = FirOperation.ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
            firOperation = FirOperation.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
            firOperation = FirOperation.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
            firOperation = FirOperation.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
            firOperation = FirOperation.DIV_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
            firOperation = FirOperation.REM_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_KEYWORD)) {
            firOperation = FirOperation.AS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_SAFE)) {
            firOperation = FirOperation.SAFE_AS;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)$this$toFirOperation.toString()));
        }
        return firOperation;
    }

    @NotNull
    public static final FirWhenExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirSession session, @NotNull FirExpression other, @NotNull String caseId, @NotNull KtElement basePsi) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateNotNullOrOther, (String)"$this$generateNotNullOrOther");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)caseId, (String)"caseId");
        Intrinsics.checkParameterIsNotNull((Object)basePsi, (String)"basePsi");
        Name name = Name.special('<' + caseId + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<$caseId>\")");
        Name subjectName = name;
        FirVariable subjectVariable = ConversionUtilsKt.generateTemporaryVariable(session, $this$generateNotNullOrOther.getPsi(), subjectName, $this$generateNotNullOrOther);
        FirWhenSubject subject = new FirWhenSubject();
        FirWhenSubjectExpressionImpl subjectExpression = new FirWhenSubjectExpressionImpl(session, $this$generateNotNullOrOther.getPsi(), subject);
        FirWhenExpressionImpl firWhenExpressionImpl = new FirWhenExpressionImpl(session, basePsi, $this$generateNotNullOrOther, subjectVariable);
        boolean bl = false;
        boolean bl2 = false;
        FirWhenExpressionImpl $this$apply = firWhenExpressionImpl;
        boolean bl3 = false;
        subject.bind($this$apply);
        Collection collection = $this$apply.getBranches();
        FirAbstractElement firAbstractElement = new FirOperatorCallImpl(session, $this$apply.getPsi(), FirOperation.EQ);
        PsiElement psiElement = $this$apply.getPsi();
        FirSession firSession = session;
        boolean bl4 = false;
        boolean bl5 = false;
        FirOperatorCallImpl $this$apply2 = firAbstractElement;
        boolean bl6 = false;
        Collection collection2 = $this$apply2.getArguments();
        FirAbstractExpression firAbstractExpression = subjectExpression;
        boolean bl7 = false;
        collection2.add(firAbstractExpression);
        collection2 = $this$apply2.getArguments();
        firAbstractExpression = new FirConstExpressionImpl<Object>(session, $this$apply2.getPsi(), IrConstKind.Null.INSTANCE, null);
        bl7 = false;
        collection2.add(firAbstractExpression);
        FirOperatorCallImpl firOperatorCallImpl = firAbstractElement;
        FirBlock firBlock = new FirSingleExpressionBlock(session, other);
        FirExpression firExpression2 = firOperatorCallImpl;
        PsiElement psiElement2 = psiElement;
        FirSession firSession2 = firSession;
        firAbstractElement = new FirWhenBranchImpl(firSession2, psiElement2, firExpression2, firBlock);
        bl4 = false;
        collection.add(firAbstractElement);
        collection = $this$apply.getBranches();
        firAbstractElement = new FirWhenBranchImpl(session, other.getPsi(), new FirElseIfTrueCondition(session, $this$apply.getPsi()), new FirSingleExpressionBlock(session, ConversionUtilsKt.generateResolvedAccessExpression(session, $this$apply.getPsi(), subjectVariable)));
        bl4 = false;
        collection.add(firAbstractElement);
        return firWhenExpressionImpl;
    }

    @NotNull
    public static final FirWhenExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirSession session, @NotNull FirExpression other, boolean isAnd, @NotNull KtElement basePsi) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateLazyLogicalOperation, (String)"$this$generateLazyLogicalOperation");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)basePsi, (String)"basePsi");
        FirConstExpressionImpl<Boolean> terminalExpression = new FirConstExpressionImpl<Boolean>(session, $this$generateLazyLogicalOperation.getPsi(), IrConstKind.Boolean.INSTANCE, !isAnd);
        FirSingleExpressionBlock terminalBlock = new FirSingleExpressionBlock(session, terminalExpression);
        FirSingleExpressionBlock otherBlock = new FirSingleExpressionBlock(session, other);
        FirWhenExpressionImpl firWhenExpressionImpl = new FirWhenExpressionImpl(session, basePsi, null, null, 12, null);
        boolean bl = false;
        boolean bl2 = false;
        FirWhenExpressionImpl $this$apply = firWhenExpressionImpl;
        boolean bl3 = false;
        Collection collection = $this$apply.getBranches();
        FirWhenBranchImpl firWhenBranchImpl = new FirWhenBranchImpl(session, $this$apply.getPsi(), $this$generateLazyLogicalOperation, isAnd ? otherBlock : terminalBlock);
        boolean bl4 = false;
        collection.add(firWhenBranchImpl);
        collection = $this$apply.getBranches();
        firWhenBranchImpl = new FirWhenBranchImpl(session, other.getPsi(), new FirElseIfTrueCondition(session, $this$apply.getPsi()), isAnd ? terminalBlock : otherBlock);
        bl4 = false;
        collection.add(firWhenBranchImpl);
        $this$apply.setTypeRef(new FirImplicitBooleanTypeRef(session, basePsi));
        return firWhenExpressionImpl;
    }

    @NotNull
    public static final FirExpression toFirWhenCondition(@NotNull KtWhenCondition $this$toFirWhenCondition, @NotNull FirSession session, @NotNull FirWhenSubject subject, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrErrorTypeRef) {
        FirExpression firExpression2;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirWhenCondition, (String)"$this$toFirWhenCondition");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        Intrinsics.checkParameterIsNotNull(toFirOrErrorTypeRef, (String)"toFirOrErrorTypeRef");
        FirWhenSubjectExpressionImpl firSubjectExpression = new FirWhenSubjectExpressionImpl(session, $this$toFirWhenCondition, subject);
        KtWhenCondition ktWhenCondition = $this$toFirWhenCondition;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            FirOperatorCallImpl firOperatorCallImpl = new FirOperatorCallImpl(session, ((KtWhenConditionWithExpression)$this$toFirWhenCondition).getExpression(), FirOperation.EQ);
            boolean bl = false;
            boolean bl2 = false;
            FirOperatorCallImpl $this$apply = firOperatorCallImpl;
            boolean bl3 = false;
            Collection collection = $this$apply.getArguments();
            Object object = firSubjectExpression;
            boolean bl4 = false;
            collection.add(object);
            collection = $this$apply.getArguments();
            object = convert.invoke((Object)((KtWhenConditionWithExpression)$this$toFirWhenCondition).getExpression(), (Object)"No expression in condition with expression");
            bl4 = false;
            collection.add(object);
            firExpression2 = firOperatorCallImpl;
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            FirExpression firRange = (FirExpression)convert.invoke((Object)((KtWhenConditionInRange)$this$toFirWhenCondition).getRangeExpression(), (Object)"No range in condition with range");
            FirExpression firExpression3 = firSubjectExpression;
            boolean bl = ((KtWhenConditionInRange)$this$toFirWhenCondition).isNegated();
            KtExpression ktExpression = ((KtWhenConditionInRange)$this$toFirWhenCondition).getRangeExpression();
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtWhenConditionInRange)$this$toFirWhenCondition).getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"operationReference");
            firExpression2 = ConversionUtilsKt.generateContainsOperation(firRange, session, firExpression3, bl, ktExpression, ktOperationReferenceExpression);
        } else if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            FirTypeOperatorCallImpl firTypeOperatorCallImpl = new FirTypeOperatorCallImpl(session, ((KtWhenConditionIsPattern)$this$toFirWhenCondition).getTypeReference(), ((KtWhenConditionIsPattern)$this$toFirWhenCondition).isNegated() ? FirOperation.NOT_IS : FirOperation.IS, (FirTypeRef)toFirOrErrorTypeRef.invoke((Object)((KtWhenConditionIsPattern)$this$toFirWhenCondition).getTypeReference()));
            boolean bl = false;
            boolean bl5 = false;
            FirTypeOperatorCallImpl $this$apply = firTypeOperatorCallImpl;
            boolean bl6 = false;
            Collection collection = $this$apply.getArguments();
            FirWhenSubjectExpressionImpl firWhenSubjectExpressionImpl = firSubjectExpression;
            boolean bl7 = false;
            collection.add(firWhenSubjectExpressionImpl);
            firExpression2 = firTypeOperatorCallImpl;
        } else {
            firExpression2 = new FirErrorExpressionImpl(session, $this$toFirWhenCondition, "Unsupported when condition: " + $this$toFirWhenCondition.getClass());
        }
        return firExpression2;
    }

    @NotNull
    public static final FirExpression toFirWhenCondition(@NotNull KtWhenCondition[] $this$toFirWhenCondition, @NotNull FirSession session, @NotNull KtElement basePsi, @NotNull FirWhenSubject subject, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrErrorTypeRef) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirWhenCondition, (String)"$this$toFirWhenCondition");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)basePsi, (String)"basePsi");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        Intrinsics.checkParameterIsNotNull(toFirOrErrorTypeRef, (String)"toFirOrErrorTypeRef");
        FirExpression firCondition = null;
        for (KtWhenCondition condition : $this$toFirWhenCondition) {
            FirExpression firConditionElement = ConversionUtilsKt.toFirWhenCondition(condition, session, subject, convert, toFirOrErrorTypeRef);
            FirExpression firExpression2 = firCondition;
            firCondition = firExpression2 == null ? firConditionElement : (FirExpression)ConversionUtilsKt.generateLazyLogicalOperation(firCondition, session, firConditionElement, false, basePsi);
        }
        FirExpression firExpression3 = firCondition;
        if (firExpression3 == null) {
            Intrinsics.throwNpe();
        }
        return firExpression3;
    }

    @NotNull
    public static final FirExpression toInterpolatingCall(@NotNull KtStringTemplateEntry[] $this$toInterpolatingCall, @NotNull FirSession session, @NotNull KtStringTemplateExpression base, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert) {
        FirExpression firExpression2;
        Intrinsics.checkParameterIsNotNull((Object)$this$toInterpolatingCall, (String)"$this$toInterpolatingCall");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        StringBuilder sb = new StringBuilder();
        boolean hasExpressions = false;
        FirExpression result2 = null;
        boolean callCreated = false;
        for (KtStringTemplateEntry entry : $this$toInterpolatingCall) {
            Object object;
            boolean bl;
            FirExpression firExpression3;
            Collection collection;
            Object $this$apply;
            boolean bl2;
            Object object2;
            FirExpression firExpression4;
            Object object3 = entry;
            if (object3 instanceof KtLiteralStringTemplateEntry) {
                sb.append(((KtLiteralStringTemplateEntry)entry).getText());
                PsiElement psiElement = entry;
                IrConstKind irConstKind = IrConstKind.String.INSTANCE;
                String string = ((KtLiteralStringTemplateEntry)entry).getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.text");
                firExpression4 = new FirConstExpressionImpl<String>(session, psiElement, irConstKind, string);
            } else if (object3 instanceof KtEscapeStringTemplateEntry) {
                sb.append(((KtEscapeStringTemplateEntry)entry).getUnescapedValue());
                PsiElement psiElement = entry;
                IrConstKind irConstKind = IrConstKind.String.INSTANCE;
                String string = ((KtEscapeStringTemplateEntry)entry).getUnescapedValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.unescapedValue");
                firExpression4 = new FirConstExpressionImpl<String>(session, psiElement, irConstKind, string);
            } else if (object3 instanceof KtStringTemplateEntryWithExpression) {
                KtExpression innerExpression = ((KtStringTemplateEntryWithExpression)entry).getExpression();
                hasExpressions = true;
                firExpression4 = (FirExpression)convert.invoke((Object)innerExpression, (Object)"Incorrect template argument");
            } else {
                hasExpressions = true;
                firExpression4 = new FirErrorExpressionImpl(session, entry, "Incorrect template entry: " + entry.getText());
            }
            FirExpression nextArgument = firExpression4;
            if (result2 == null) {
                object2 = nextArgument;
            } else if (callCreated && result2 instanceof FirStringConcatenationCallImpl) {
                object3 = result2;
                boolean bl3 = false;
                bl2 = false;
                $this$apply = (FirStringConcatenationCallImpl)object3;
                boolean bl4 = false;
                collection = ((FirAbstractCall)$this$apply).getArguments();
                firExpression3 = nextArgument;
                bl = false;
                collection.add(firExpression3);
                object2 = object = object3;
            } else {
                callCreated = true;
                object3 = new FirStringConcatenationCallImpl(session, base);
                boolean bl5 = false;
                bl2 = false;
                $this$apply = object3;
                boolean bl6 = false;
                collection = ((FirAbstractCall)$this$apply).getArguments();
                FirExpression firExpression5 = result2;
                if (firExpression5 == null) {
                    Intrinsics.throwNpe();
                }
                firExpression3 = firExpression5;
                bl = false;
                collection.add(firExpression3);
                collection = ((FirAbstractCall)$this$apply).getArguments();
                firExpression3 = nextArgument;
                bl = false;
                collection.add(firExpression3);
                object = object3;
                object2 = (FirExpression)object;
            }
            result2 = object2;
        }
        if (hasExpressions) {
            firExpression2 = result2;
            if (firExpression2 == null) {
                Intrinsics.throwNpe();
            }
        } else {
            PsiElement psiElement = base;
            IrConstKind irConstKind = IrConstKind.String.INSTANCE;
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            firExpression2 = new FirConstExpressionImpl<String>(session, psiElement, irConstKind, string);
        }
        return firExpression2;
    }

    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirSession session, @NotNull FirExpression argument, boolean inverted, @Nullable KtExpression base, @NotNull KtOperationReferenceExpression operationReference) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateContainsOperation, (String)"$this$generateContainsOperation");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)operationReference, (String)"operationReference");
        FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(session, base, false, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        FirFunctionCallImpl $this$apply = firFunctionCallImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(session, operationReference, OperatorNameConventions.CONTAINS));
        $this$apply.setExplicitReceiver($this$generateContainsOperation);
        Collection collection = $this$apply.getArguments();
        FirExpression firExpression2 = argument;
        boolean bl4 = false;
        collection.add(firExpression2);
        FirFunctionCallImpl containsCall = firFunctionCallImpl;
        if (!inverted) {
            return containsCall;
        }
        firFunctionCallImpl = new FirFunctionCallImpl(session, base, false, 4, null);
        bl = false;
        bl2 = false;
        $this$apply = firFunctionCallImpl;
        boolean bl5 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(session, operationReference, OperatorNameConventions.NOT));
        $this$apply.setExplicitReceiver(containsCall);
        return firFunctionCallImpl;
    }

    @NotNull
    public static final FirExpression generateIncrementOrDecrementBlock(@NotNull FirSession session, @NotNull KtUnaryExpression baseExpression, @Nullable KtExpression argument, @NotNull Name callName, boolean prefix, @NotNull Function1<? super KtExpression, ? extends FirExpression> convert) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)baseExpression, (String)"baseExpression");
        Intrinsics.checkParameterIsNotNull((Object)callName, (String)"callName");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        if (argument == null) {
            return new FirErrorExpressionImpl(session, argument, "Inc/dec without operand");
        }
        FirBlockImpl firBlockImpl = new FirBlockImpl(session, baseExpression);
        boolean bl = false;
        boolean bl2 = false;
        FirBlockImpl $this$apply = firBlockImpl;
        boolean bl3 = false;
        Name name = Name.special("<unary>");
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<unary>\")");
        Name tempName = name;
        FirVariable temporaryVariable = ConversionUtilsKt.generateTemporaryVariable(session, (PsiElement)baseExpression, tempName, (FirExpression)convert.invoke((Object)argument));
        Collection collection2 = $this$apply.getStatements();
        boolean bl4 = false;
        collection2.add(temporaryVariable);
        Name name2 = Name.special("<unary-result>");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<unary-result>\")");
        Name resultName = name2;
        FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(session, baseExpression, false, 4, null);
        boolean bl5 = false;
        boolean bl6 = false;
        FirFunctionCallImpl $this$apply2 = firFunctionCallImpl;
        boolean bl7 = false;
        $this$apply2.setCalleeReference(new FirSimpleNamedReference(session, baseExpression.getOperationReference(), callName));
        $this$apply2.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(session, baseExpression, temporaryVariable));
        FirFunctionCallImpl resultInitializer = firFunctionCallImpl;
        FirVariable resultVar = ConversionUtilsKt.generateTemporaryVariable(session, (PsiElement)baseExpression, resultName, (FirExpression)resultInitializer);
        FirStatement assignment = ConversionUtilsKt.generateAssignment(argument, session, baseExpression, (FirExpression)(prefix && !(argument instanceof KtSimpleNameExpression) ? (FirStatement)ConversionUtilsKt.generateResolvedAccessExpression(session, baseExpression, resultVar) : (FirStatement)resultInitializer), FirOperation.ASSIGN, convert);
        Function0<Unit> $fun$appendAssignment$1 = new Function0<Unit>($this$apply, assignment){
            final /* synthetic */ FirBlockImpl $this_apply;
            final /* synthetic */ FirStatement $assignment;

            public final void invoke() {
                if (this.$assignment instanceof FirBlock) {
                    Collection collection = this.$this_apply.getStatements();
                    Iterable iterable = ((FirBlock)this.$assignment).getStatements();
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                } else {
                    Collection collection = this.$this_apply.getStatements();
                    FirStatement firStatement = this.$assignment;
                    boolean bl = false;
                    collection.add(firStatement);
                }
            }
            {
                this.$this_apply = firBlockImpl;
                this.$assignment = firStatement;
                super(0);
            }
        };
        if (prefix) {
            if (!(argument instanceof KtSimpleNameExpression)) {
                collection = $this$apply.getStatements();
                boolean bl8 = false;
                collection.add(resultVar);
                $fun$appendAssignment$1.invoke();
                collection = $this$apply.getStatements();
                FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateResolvedAccessExpression(session, baseExpression, resultVar);
                boolean bl9 = false;
                collection.add(firQualifiedAccessExpression);
            } else {
                $fun$appendAssignment$1.invoke();
                collection = $this$apply.getStatements();
                FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateAccessExpression(session, baseExpression, ((KtSimpleNameExpression)argument).getReferencedNameAsName());
                boolean bl10 = false;
                collection.add(firQualifiedAccessExpression);
            }
        } else {
            $fun$appendAssignment$1.invoke();
            collection = $this$apply.getStatements();
            FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateResolvedAccessExpression(session, baseExpression, temporaryVariable);
            boolean bl11 = false;
            collection.add(firQualifiedAccessExpression);
        }
        return firBlockImpl;
    }

    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@NotNull FirSession session, @Nullable PsiElement psi, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(session, psi, false, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(session, psi, name));
        return firQualifiedAccessExpressionImpl;
    }

    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@NotNull FirSession session, @Nullable PsiElement psi, @NotNull FirVariable variable2) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(session, psi, false, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirResolvedCallableReferenceImpl(session, psi, variable2.getName(), variable2.getSymbol()));
        return firQualifiedAccessExpressionImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirExpression generateDestructuringBlock(@NotNull FirSession session, @NotNull KtDestructuringDeclaration multiDeclaration, @NotNull FirVariable container, boolean tmpVariable, @NotNull Function2<? super KtAnnotated, ? super FirAbstractAnnotatedElement, Unit> extractAnnotationsTo, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrImplicitTypeRef) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)multiDeclaration, (String)"multiDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull(extractAnnotationsTo, (String)"extractAnnotationsTo");
        Intrinsics.checkParameterIsNotNull(toFirOrImplicitTypeRef, (String)"toFirOrImplicitTypeRef");
        FirBlockImpl firBlockImpl = new FirBlockImpl(session, multiDeclaration);
        boolean bl = false;
        boolean bl2 = false;
        FirBlockImpl $this$apply = firBlockImpl;
        boolean bl3 = false;
        if (tmpVariable) {
            Collection collection = $this$apply.getStatements();
            FirVariable firVariable = container;
            boolean bl4 = false;
            collection.add(firVariable);
        }
        boolean isVar = multiDeclaration.isVar();
        boolean bl5 = false;
        List<KtDestructuringDeclarationEntry> list2 = multiDeclaration.getEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"multiDeclaration.entries");
        for (KtDestructuringDeclarationEntry entry : (Iterable)list2) {
            void index2;
            Collection collection = $this$apply.getStatements();
            PsiElement psiElement = entry;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"entry");
            Name name = ktDestructuringDeclarationEntry.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"entry.nameAsSafeName");
            FirTypeRef firTypeRef = (FirTypeRef)toFirOrImplicitTypeRef.invoke((Object)entry.getTypeReference());
            FirExpression firExpression2 = new FirComponentCallImpl(session, entry, (int)(index2 + true), ConversionUtilsKt.generateResolvedAccessExpression(session, entry, container));
            Name name2 = entry.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"entry.nameAsSafeName");
            FirVariableImpl firVariableImpl = new FirVariableImpl(session, psiElement, name, firTypeRef, isVar, firExpression2, new FirVariableSymbol(name2), null, 128, null);
            boolean bl6 = false;
            boolean bl7 = false;
            FirVariableImpl $this$apply2 = firVariableImpl;
            boolean bl8 = false;
            extractAnnotationsTo.invoke((Object)entry, (Object)$this$apply2);
            $this$apply2.getSymbol().bind((FirElement)$this$apply2);
            bl6 = false;
            collection.add(firVariableImpl);
            ++index2;
        }
        return firBlockImpl;
    }

    @NotNull
    public static final FirVariable generateTemporaryVariable(@NotNull FirSession session, @Nullable PsiElement psi, @NotNull Name name, @NotNull FirExpression initializer2) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)initializer2, (String)"initializer");
        FirVariableImpl firVariableImpl = new FirVariableImpl(session, psi, name, new FirImplicitTypeRefImpl(session, psi), false, initializer2, new FirVariableSymbol(name), null, 128, null);
        boolean bl = false;
        boolean bl2 = false;
        FirVariableImpl $this$apply = firVariableImpl;
        boolean bl3 = false;
        $this$apply.getSymbol().bind((FirElement)$this$apply);
        return firVariableImpl;
    }

    @NotNull
    public static final FirVariable generateTemporaryVariable(@NotNull FirSession session, @Nullable PsiElement psi, @NotNull String specialName, @NotNull FirExpression initializer2) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)specialName, (String)"specialName");
        Intrinsics.checkParameterIsNotNull((Object)initializer2, (String)"initializer");
        Name name = Name.special('<' + specialName + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<$specialName>\")");
        return ConversionUtilsKt.generateTemporaryVariable(session, psi, name, initializer2);
    }

    private static final FirReference initializeLValue(@NotNull FirModifiableQualifiedAccess $this$initializeLValue, FirSession session, KtExpression left, Function1<? super KtQualifiedExpression, ? extends FirQualifiedAccess> convertQualified) {
        FirReference firReference;
        KtExpression ktExpression = left;
        if (ktExpression instanceof KtSimpleNameExpression) {
            firReference = new FirSimpleNamedReference(session, left, ((KtSimpleNameExpression)left).getReferencedNameAsName());
        } else if (ktExpression instanceof KtThisExpression) {
            firReference = new FirExplicitThisReference(session, left, ((KtThisExpression)left).getLabelName());
        } else if (ktExpression instanceof KtQualifiedExpression) {
            FirQualifiedAccess firMemberAccess = (FirQualifiedAccess)convertQualified.invoke((Object)left);
            if (firMemberAccess != null) {
                $this$initializeLValue.setExplicitReceiver(firMemberAccess.getExplicitReceiver());
                $this$initializeLValue.setSafe(firMemberAccess.getSafe());
                firReference = firMemberAccess.getCalleeReference();
            } else {
                firReference = new FirErrorNamedReference(session, left, "Unsupported qualified LValue: " + ((KtQualifiedExpression)left).getText(), null, 8, null);
            }
        } else if (ktExpression instanceof KtParenthesizedExpression) {
            firReference = ConversionUtilsKt.initializeLValue($this$initializeLValue, session, ((KtParenthesizedExpression)left).getExpression(), convertQualified);
        } else {
            KtExpression ktExpression2 = left;
            firReference = new FirErrorNamedReference(session, left, "Unsupported LValue: " + (ktExpression2 != null ? ktExpression2.getClass() : null), null, 8, null);
        }
        return firReference;
    }

    @NotNull
    public static final FirStatement generateAssignment(@Nullable KtExpression $this$generateAssignment, @NotNull FirSession session, @Nullable PsiElement psi, @NotNull FirExpression value, @NotNull FirOperation operation, @NotNull Function1<? super KtExpression, ? extends FirExpression> convert) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)((Object)operation), (String)"operation");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        if ($this$generateAssignment instanceof KtParenthesizedExpression) {
            return ConversionUtilsKt.generateAssignment(((KtParenthesizedExpression)$this$generateAssignment).getExpression(), session, psi, value, operation, convert);
        }
        if ($this$generateAssignment instanceof KtArrayAccessExpression) {
            boolean bl;
            Object object;
            FirArraySetCallImpl $this$apply;
            boolean bl2;
            boolean bl3;
            FirAbstractAnnotatedElement firAbstractAnnotatedElement;
            Object firArrayExpression;
            KtExpression arrayExpression = ((KtArrayAccessExpression)$this$generateAssignment).getArrayExpression();
            Object object2 = arrayExpression;
            if (object2 == null || (object2 = (FirExpression)convert.invoke(object2)) == null) {
                object2 = firArrayExpression = (FirExpression)new FirErrorExpressionImpl(session, arrayExpression, "No array expression");
            }
            if (operation != FirOperation.ASSIGN) {
                firAbstractAnnotatedElement = new FirArraySetCallImpl(session, psi, value, operation);
                bl3 = false;
                bl2 = false;
                $this$apply = firAbstractAnnotatedElement;
                boolean bl4 = false;
                for (KtExpression indexExpression : ((KtArrayAccessExpression)$this$generateAssignment).getIndexExpressions()) {
                    object = $this$apply.getIndexes();
                    KtExpression ktExpression = indexExpression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"indexExpression");
                    Object object3 = convert.invoke((Object)ktExpression);
                    bl = false;
                    object.add(object3);
                }
            } else {
                FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(session, psi, false, 4, null);
                boolean bl5 = false;
                boolean bl6 = false;
                FirFunctionCallImpl $this$apply2 = firFunctionCallImpl;
                boolean bl7 = false;
                $this$apply2.setCalleeReference(new FirSimpleNamedReference(session, psi, OperatorNameConventions.SET));
                $this$apply2.setExplicitReceiver((FirExpression)firArrayExpression);
                for (KtExpression indexExpression : ((KtArrayAccessExpression)$this$generateAssignment).getIndexExpressions()) {
                    Collection collection = $this$apply2.getArguments();
                    KtExpression ktExpression = indexExpression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"indexExpression");
                    Object object4 = convert.invoke((Object)ktExpression);
                    boolean bl8 = false;
                    collection.add(object4);
                }
                Collection collection = $this$apply2.getArguments();
                FirExpression firExpression2 = value;
                boolean bl9 = false;
                collection.add(firExpression2);
                return firFunctionCallImpl;
            }
            FirArraySetCallImpl arraySet = firAbstractAnnotatedElement;
            if (arrayExpression instanceof KtSimpleNameExpression) {
                firAbstractAnnotatedElement = arraySet;
                bl3 = false;
                bl2 = false;
                $this$apply = firAbstractAnnotatedElement;
                boolean bl10 = false;
                $this$apply.setLValue(ConversionUtilsKt.initializeLValue($this$apply, session, arrayExpression, (Function1<? super KtQualifiedExpression, ? extends FirQualifiedAccess>)((Function1)new Function1<KtQualifiedExpression, FirQualifiedAccess>(session, arrayExpression, convert){
                    final /* synthetic */ FirSession $session$inlined;
                    final /* synthetic */ KtExpression $arrayExpression$inlined;
                    final /* synthetic */ Function1 $convert$inlined;
                    {
                        this.$session$inlined = firSession;
                        this.$arrayExpression$inlined = ktExpression;
                        this.$convert$inlined = function1;
                        super(1);
                    }

                    @Nullable
                    public final FirQualifiedAccess invoke(@NotNull KtQualifiedExpression $this$initializeLValue) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$initializeLValue, (String)"$receiver");
                        Object object = this.$convert$inlined.invoke((Object)$this$initializeLValue);
                        if (!(object instanceof FirQualifiedAccess)) {
                            object = null;
                        }
                        return (FirQualifiedAccess)object;
                    }
                })));
                return firAbstractAnnotatedElement;
            }
            firAbstractAnnotatedElement = new FirBlockImpl(session, arrayExpression);
            bl3 = false;
            bl2 = false;
            $this$apply = firAbstractAnnotatedElement;
            boolean bl11 = false;
            Name name = Name.special("<array-set>");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<array-set>\")");
            Name name2 = name;
            Collection collection = ((FirBlockImpl)((Object)$this$apply)).getStatements();
            object = ConversionUtilsKt.generateTemporaryVariable(session, (PsiElement)$this$generateAssignment, name2, (FirExpression)firArrayExpression);
            boolean bl12 = false;
            collection.add(object);
            collection = ((FirBlockImpl)((Object)$this$apply)).getStatements();
            object = arraySet;
            bl12 = false;
            bl = false;
            Object $this$apply3 = object;
            boolean bl13 = false;
            ((FirAbstractAssignment)$this$apply3).setLValue(new FirSimpleNamedReference(session, arrayExpression, name2));
            bl12 = false;
            collection.add(object);
            return firAbstractAnnotatedElement;
        }
        if (!(operation == FirOperation.ASSIGN || $this$generateAssignment instanceof KtSimpleNameExpression || $this$generateAssignment instanceof KtThisExpression || $this$generateAssignment instanceof KtQualifiedExpression && ((KtQualifiedExpression)$this$generateAssignment).getSelectorExpression() instanceof KtSimpleNameExpression)) {
            FirBlockImpl firBlockImpl = new FirBlockImpl(session, $this$generateAssignment);
            boolean bl = false;
            boolean bl14 = false;
            FirBlockImpl $this$apply = firBlockImpl;
            boolean bl15 = false;
            Name name = Name.special("<complex-set>");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<complex-set>\")");
            Name name3 = name;
            Collection collection = $this$apply.getStatements();
            PsiElement psiElement = $this$generateAssignment;
            Object object = $this$generateAssignment;
            if (object == null || (object = (FirExpression)convert.invoke(object)) == null) {
                object = new FirErrorExpressionImpl(session, $this$generateAssignment, "No LValue in assignment");
            }
            FirStatement firStatement = ConversionUtilsKt.generateTemporaryVariable(session, psiElement, name3, (FirExpression)object);
            boolean bl16 = false;
            collection.add(firStatement);
            collection = $this$apply.getStatements();
            firStatement = new FirVariableAssignmentImpl(session, psi, value, operation, false, 16, null);
            bl16 = false;
            boolean bl17 = false;
            FirStatement $this$apply4 = firStatement;
            boolean bl18 = false;
            ((FirAbstractAssignment)$this$apply4).setLValue(new FirSimpleNamedReference(session, $this$generateAssignment, name3));
            bl16 = false;
            collection.add(firStatement);
            return firBlockImpl;
        }
        FirVariableAssignmentImpl firVariableAssignmentImpl = new FirVariableAssignmentImpl(session, psi, value, operation, false, 16, null);
        boolean bl = false;
        boolean bl19 = false;
        FirVariableAssignmentImpl $this$apply = firVariableAssignmentImpl;
        boolean bl20 = false;
        $this$apply.setLValue(ConversionUtilsKt.initializeLValue($this$apply, session, $this$generateAssignment, (Function1<? super KtQualifiedExpression, ? extends FirQualifiedAccess>)((Function1)new Function1<KtQualifiedExpression, FirQualifiedAccess>($this$generateAssignment, session, convert){
            final /* synthetic */ KtExpression $this_generateAssignment$inlined;
            final /* synthetic */ FirSession $session$inlined;
            final /* synthetic */ Function1 $convert$inlined;
            {
                this.$this_generateAssignment$inlined = ktExpression;
                this.$session$inlined = firSession;
                this.$convert$inlined = function1;
                super(1);
            }

            @Nullable
            public final FirQualifiedAccess invoke(@NotNull KtQualifiedExpression $this$initializeLValue) {
                Intrinsics.checkParameterIsNotNull((Object)$this$initializeLValue, (String)"$receiver");
                Object object = this.$convert$inlined.invoke((Object)$this$initializeLValue);
                if (!(object instanceof FirQualifiedAccess)) {
                    object = null;
                }
                return (FirQualifiedAccess)object;
            }
        })));
        return firVariableAssignmentImpl;
    }
}

