/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.zapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fusesource.hawtbuf.Buffer;
import org.sonatype.spice.zapper.IOSource;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.codec.Codec;
import org.sonatype.spice.zapper.hash.Hash;
import org.sonatype.spice.zapper.hash.HashAlgorithm;
import org.sonatype.spice.zapper.hash.HashUtils;
import org.sonatype.spice.zapper.internal.Segment;
import org.sonatype.spice.zapper.internal.SegmentIdentifier;
import org.sonatype.spice.zapper.internal.SegmentPayload;
import org.sonatype.spice.zapper.internal.TransferIdentifier;
import org.sonatype.spice.zapper.internal.hawtbuf.SegmentFooter;
import org.sonatype.spice.zapper.internal.hawtbuf.SegmentHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZapperPayload
extends SegmentPayload {
    private final byte[] header = this.createSegmentHeader();
    private final byte[] footer = this.createSegmentFooter();
    private final Hash envelopeHash;

    public ZapperPayload(TransferIdentifier transferIdentifier, Path path, Segment segment, IOSource ioSource, HashAlgorithm hashAlgorithm, Hash segmentHash, List<Codec> codecs) throws IOException {
        super(transferIdentifier, path, segment, ioSource, segmentHash, codecs);
        this.envelopeHash = HashUtils.getDigest(hashAlgorithm, this.getContent());
    }

    @Override
    public long getLength() {
        return (long)this.header.length + super.getLength() + (long)this.footer.length;
    }

    @Override
    public Hash getHash() {
        return this.envelopeHash;
    }

    @Override
    public InputStream getContent() throws IOException {
        ArrayList<InputStream> parts = new ArrayList<InputStream>(3);
        parts.add(new ByteArrayInputStream(this.header));
        parts.add(super.getContent());
        parts.add(new ByteArrayInputStream(this.footer));
        return new SequenceInputStream(Collections.enumeration(parts));
    }

    protected byte[] createSegmentHeader() {
        SegmentHeader header = (SegmentHeader)((Object)((SegmentHeader)((Object)((SegmentHeader)((Object)((SegmentHeader)((Object)new SegmentHeader().setFileId(((Path)this.getSegment().getZFile().getIdentifier()).stringValue()))).setSegmentId(((SegmentIdentifier)this.getIdentifier()).stringValue()))).setSegmentOffset(this.getSegment().getOffset()))).setSegmentLength(this.getSegment().getLength()));
        return header.toFramedByteArray();
    }

    protected byte[] createSegmentFooter() {
        SegmentFooter footer = new SegmentFooter();
        Hash bodyHash = super.getHash();
        footer.addHashes((org.sonatype.spice.zapper.internal.hawtbuf.Hash)((Object)((org.sonatype.spice.zapper.internal.hawtbuf.Hash)((Object)new org.sonatype.spice.zapper.internal.hawtbuf.Hash().setHashAlg(bodyHash.getHashAlgorithmIdentifier().stringValue()))).setHashBytes(new Buffer(bodyHash.byteValue()))));
        return footer.toFramedByteArray();
    }
}

