/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.proto.BaseMessage;
import org.sonatype.spice.zapper.internal.hawtbuf.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TransferMessageBase<T>
extends BaseMessage<T> {
    private String f_magic = "zRec";
    private boolean b_magic;
    private String f_transferId = null;
    private boolean b_transferId;
    private long f_transferTotalSize = 0L;
    private boolean b_transferTotalSize;
    private List<File> f_files;

    TransferMessageBase() {
    }

    public boolean hasMagic() {
        return this.b_magic;
    }

    public String getMagic() {
        return this.f_magic;
    }

    public T setMagic(String magic) {
        this.loadAndClear();
        this.b_magic = true;
        this.f_magic = magic;
        return (T)((Object)this);
    }

    public void clearMagic() {
        this.loadAndClear();
        this.b_magic = false;
        this.f_magic = "zRec";
    }

    public boolean hasTransferId() {
        return this.b_transferId;
    }

    public String getTransferId() {
        return this.f_transferId;
    }

    public T setTransferId(String transferId) {
        this.loadAndClear();
        this.b_transferId = true;
        this.f_transferId = transferId;
        return (T)((Object)this);
    }

    public void clearTransferId() {
        this.loadAndClear();
        this.b_transferId = false;
        this.f_transferId = null;
    }

    public boolean hasTransferTotalSize() {
        return this.b_transferTotalSize;
    }

    public long getTransferTotalSize() {
        return this.f_transferTotalSize;
    }

    public T setTransferTotalSize(long transferTotalSize) {
        this.loadAndClear();
        this.b_transferTotalSize = true;
        this.f_transferTotalSize = transferTotalSize;
        return (T)((Object)this);
    }

    public void clearTransferTotalSize() {
        this.loadAndClear();
        this.b_transferTotalSize = false;
        this.f_transferTotalSize = 0L;
    }

    public boolean hasFiles() {
        return this.f_files != null && !this.f_files.isEmpty();
    }

    public List<File> getFilesList() {
        if (this.f_files == null) {
            this.f_files = new ArrayList<File>();
        }
        return this.f_files;
    }

    public T setFilesList(List<File> files) {
        this.loadAndClear();
        this.f_files = files;
        return (T)((Object)this);
    }

    public int getFilesCount() {
        if (this.f_files == null) {
            return 0;
        }
        return this.f_files.size();
    }

    public File getFiles(int index) {
        if (this.f_files == null) {
            return null;
        }
        return this.f_files.get(index);
    }

    public T setFiles(int index, File value) {
        this.loadAndClear();
        this.getFilesList().set(index, value);
        return (T)((Object)this);
    }

    public T addFiles(File value) {
        this.loadAndClear();
        this.getFilesList().add(value);
        return (T)((Object)this);
    }

    public T addAllFiles(Iterable<? extends File> collection) {
        this.loadAndClear();
        BaseMessage.addAll(collection, this.getFilesList());
        return (T)((Object)this);
    }

    public void clearFiles() {
        this.loadAndClear();
        this.f_files = null;
    }
}

