/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLInfoHandler
extends AbstractXMLHandler
implements ISVNInfoHandler {
    private static final String INFO_TAG = "info";
    private static final String ENTRY_TAG = "entry";
    private static final String REVISION_ATTR = "revision";
    private static final String PATH_ATTR = "path";
    private static final String KIND_ATTR = "kind";
    private static final String URL_TAG = "url";
    private static final String REPOSITORY_TAG = "repository";
    private static final String UUID_TAG = "uuid";
    private static final String ROOT_TAG = "root";
    private static final String WC_INFO_TAG = "wc-info";
    private static final String SCHEDULE_TAG = "schedule";
    private static final String COPY_FROM_URL_TAG = "copy-from-url";
    private static final String COPY_FROM_REVISION_TAG = "copy-from-rev";
    private static final String CHECKSUM_TAG = "checksum";
    private static final String TEXT_TIME_TAG = "text-update";
    private static final String PROP_TIME_TAG = "prop-updated";
    private static final String COMMIT_TAG = "commit";
    private static final String AUTHOR_TAG = "author";
    private static final String DATE_TAG = "date";
    private static final String CONFLICT_TAG = "conflict";
    private static final String OLD_CONFLICT_TAG = "prev-base-file";
    private static final String WRK_CONFLICT_TAG = "prev-wc-file";
    private static final String NEW_CONFLICT_TAG = "cur-base-file";
    private static final String PROP_CONFLICT_TAG = "prop-file";
    private static final String TOKEN_TAG = "token";
    private static final String OWNER_TAG = "owner";
    private static final String COMMENT_TAG = "comment";
    private static final String CREATED_TAG = "created";
    private static final String EXPIRES_TAG = "expires";
    private static final String LOCK_TAG = "lock";
    private File myTargetPath;

    public SVNXMLInfoHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLInfoHandler(ContentHandler contentHandler, ISVNDebugLog log) {
        super(contentHandler, log);
    }

    public void setTargetPath(File path) {
        this.myTargetPath = path;
    }

    protected String getHeaderName() {
        return INFO_TAG;
    }

    public void handleInfo(SVNInfo info) throws SVNException {
        try {
            this.sendToHandler(info);
        }
        catch (SAXException e) {
            this.getDebugLog().error(e);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, e.getMessage());
            SVNErrorManager.error(err, e);
        }
    }

    private void sendToHandler(SVNInfo info) throws SAXException {
        this.addAttribute(KIND_ATTR, info.getKind().toString());
        if (info.getFile() != null) {
            this.addAttribute(PATH_ATTR, this.getRelativePath(info.getFile()));
        } else if (info.getPath() != null) {
            this.addAttribute(PATH_ATTR, info.getPath());
        }
        this.addAttribute(REVISION_ATTR, info.getRevision().toString());
        this.openTag(ENTRY_TAG);
        if (info.getURL() != null) {
            this.addTag(URL_TAG, info.getURL().toString());
        }
        SVNURL rootURL = info.getRepositoryRootURL();
        String uuid = info.getRepositoryUUID();
        if (rootURL != null || uuid != null) {
            this.openTag(REPOSITORY_TAG);
            if (rootURL != null) {
                this.addTag(ROOT_TAG, rootURL.toString());
            }
            if (uuid != null) {
                this.addTag(UUID_TAG, uuid);
            }
            this.closeTag(REPOSITORY_TAG);
        }
        if (info.getFile() != null) {
            this.openTag(WC_INFO_TAG);
            String schedule = info.getSchedule();
            if (schedule == null || "".equals(schedule)) {
                schedule = "normal";
            }
            this.addTag(SCHEDULE_TAG, schedule);
            if (info.getCopyFromURL() != null) {
                this.addTag(COPY_FROM_URL_TAG, info.getCopyFromURL().toString());
            }
            if (info.getCopyFromRevision() != null && info.getCopyFromRevision().isValid()) {
                this.addTag(COPY_FROM_REVISION_TAG, info.getCopyFromRevision().toString());
            }
            if (info.getTextTime() != null) {
                this.addTag(TEXT_TIME_TAG, SVNTimeUtil.formatDate(info.getTextTime()));
            }
            if (info.getPropTime() != null) {
                this.addTag(PROP_TIME_TAG, SVNTimeUtil.formatDate(info.getPropTime()));
            }
            if (info.getChecksum() != null) {
                this.addTag(CHECKSUM_TAG, info.getChecksum());
            }
            this.closeTag(WC_INFO_TAG);
        }
        if (info.getAuthor() != null || info.getCommittedRevision().isValid() || info.getCommittedDate() != null) {
            if (info.getCommittedRevision().isValid()) {
                this.addAttribute(REVISION_ATTR, info.getCommittedRevision().toString());
            }
            this.openTag(COMMIT_TAG);
            this.addTag(AUTHOR_TAG, info.getAuthor());
            if (info.getCommittedDate() != null) {
                this.addTag(DATE_TAG, SVNTimeUtil.formatDate(info.getCommittedDate()));
            }
            this.closeTag(COMMIT_TAG);
        }
        if (info.getConflictNewFile() != null || info.getConflictOldFile() != null || info.getConflictWrkFile() != null || info.getPropConflictFile() != null) {
            this.openTag(CONFLICT_TAG);
            if (info.getConflictOldFile() != null) {
                this.addTag(OLD_CONFLICT_TAG, info.getConflictOldFile().getName());
            }
            if (info.getConflictWrkFile() != null) {
                this.addTag(WRK_CONFLICT_TAG, info.getConflictWrkFile().getName());
            }
            if (info.getConflictNewFile() != null) {
                this.addTag(NEW_CONFLICT_TAG, info.getConflictNewFile().getName());
            }
            if (info.getPropConflictFile() != null) {
                this.addTag(PROP_CONFLICT_TAG, info.getPropConflictFile().getName());
            }
            this.closeTag(CONFLICT_TAG);
        }
        if (info.getLock() != null) {
            SVNLock lock = info.getLock();
            this.openTag(LOCK_TAG);
            if (lock.getID() != null) {
                this.addTag(TOKEN_TAG, lock.getID());
            }
            if (lock.getOwner() != null) {
                this.addTag(OWNER_TAG, lock.getOwner());
            }
            if (lock.getComment() != null) {
                this.addTag(COMMENT_TAG, lock.getComment());
            }
            if (lock.getCreationDate() != null) {
                this.addTag(CREATED_TAG, SVNTimeUtil.formatDate(lock.getCreationDate()));
            }
            if (lock.getExpirationDate() != null) {
                this.addTag(EXPIRES_TAG, SVNTimeUtil.formatDate(lock.getExpirationDate()));
            }
            this.closeTag(LOCK_TAG);
        }
        this.closeTag(ENTRY_TAG);
    }

    protected String getRelativePath(File path) {
        String fullPath = path.getAbsoluteFile().getAbsolutePath();
        if (this.myTargetPath == null) {
            return fullPath;
        }
        StringBuffer relativePath = new StringBuffer();
        char pathSeparator = File.separatorChar;
        boolean targetMeet = false;
        if (!path.getAbsoluteFile().equals(this.myTargetPath.getAbsoluteFile())) {
            do {
                if (relativePath.length() > 0) {
                    relativePath.insert(0, pathSeparator);
                }
                relativePath = relativePath.insert(0, path.getName());
                if ((path = path.getParentFile()) == null) continue;
                targetMeet = path.getAbsoluteFile().equals(this.myTargetPath.getAbsoluteFile());
            } while (path != null && !targetMeet);
        } else {
            return this.myTargetPath.getPath();
        }
        if (path != null) {
            if (relativePath.length() > 0) {
                relativePath.insert(0, pathSeparator);
            }
        } else {
            return fullPath;
        }
        relativePath = relativePath.insert(0, this.myTargetPath.getPath());
        return relativePath.toString();
    }

    protected String getTargetPath() {
        return this.getRelativePath(this.myTargetPath);
    }
}

