/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

class SVNCommitEditor
implements ISVNEditor {
    private SVNConnection myConnection;
    private SVNRepositoryImpl myRepository;
    private ISVNCommitCallback myCloseCallback;
    private Stack myDirsStack;
    private int myNextToken;
    private Map myFilesToTokens;
    private int myDiffWindowCount = 0;
    private boolean myIsAborted;

    public SVNCommitEditor(SVNRepositoryImpl location, SVNConnection connection, ISVNCommitCallback closeCallback) {
        this.myRepository = location;
        this.myConnection = connection;
        this.myCloseCallback = closeCallback;
        this.myDirsStack = new Stack();
        this.myNextToken = 0;
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void openRoot(long revision) throws SVNException {
        DirBaton rootBaton = new DirBaton(this.myNextToken++);
        this.myConnection.write("(w((n)s))", new Object[]{"open-root", SVNCommitEditor.getRevisionObject(revision), rootBaton.getToken()});
        this.myDirsStack.push(rootBaton);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        this.myConnection.write("(w(s(n)s))", new Object[]{"delete-entry", path, SVNCommitEditor.getRevisionObject(revision), parentBaton.getToken()});
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        DirBaton dirBaton = new DirBaton(this.myNextToken++);
        if (copyFromPath != null) {
            String rootURL = this.myRepository.getRepositoryRoot(false).toString();
            copyFromPath = SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(this.myRepository.getRepositoryPath(copyFromPath)));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-dir", path, parentBaton.getToken(), dirBaton.getToken(), copyFromPath, SVNCommitEditor.getRevisionObject(copyFromRevision)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-dir", path, parentBaton.getToken(), dirBaton.getToken()});
        }
        this.myDirsStack.push(dirBaton);
    }

    public void openDir(String path, long revision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        DirBaton dirBaton = new DirBaton(this.myNextToken++);
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-dir", path, parentBaton.getToken(), dirBaton.getToken(), SVNCommitEditor.getRevisionObject(revision)});
        this.myDirsStack.push(dirBaton);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        DirBaton dirBaton = (DirBaton)this.myDirsStack.peek();
        this.myConnection.write("(w(ss(s)))", new Object[]{"change-dir-prop", dirBaton.getToken(), name, value});
    }

    public void closeDir() throws SVNException {
        DirBaton dirBaton = (DirBaton)this.myDirsStack.pop();
        this.myConnection.write("(w(s))", new Object[]{"close-dir", dirBaton.getToken()});
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        String fileToken = "c" + this.myNextToken++;
        if (copyFromPath != null) {
            String host = this.myRepository.getRepositoryRoot(false).toString();
            copyFromPath = SVNPathUtil.append(host, SVNEncodingUtil.uriEncode(this.myRepository.getRepositoryPath(copyFromPath)));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-file", path, parentBaton.getToken(), fileToken, copyFromPath, SVNCommitEditor.getRevisionObject(copyFromRevision)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-file", path, parentBaton.getToken(), fileToken});
        }
        if (this.myFilesToTokens == null) {
            this.myFilesToTokens = new HashMap();
        }
        this.myFilesToTokens.put(path, fileToken);
    }

    public void openFile(String path, long revision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        String fileToken = "c" + this.myNextToken++;
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-file", path, parentBaton.getToken(), fileToken, SVNCommitEditor.getRevisionObject(revision)});
        if (this.myFilesToTokens == null) {
            this.myFilesToTokens = new HashMap();
        }
        this.myFilesToTokens.put(path, fileToken);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.get(path);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s(s)))", new Object[]{"apply-textdelta", fileToken, baseChecksum});
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.get(path);
        try {
            diffWindow.writeTo(new SVNDeltaStream(fileToken), this.myDiffWindowCount == 0, this.myConnection.isSVNDiff1());
            ++this.myDiffWindowCount;
            return SVNFileUtil.DUMMY_OUT;
        }
        catch (IOException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e);
            return null;
        }
    }

    public void textDeltaEnd(String path) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.get(path);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s))", new Object[]{"textdelta-end", fileToken});
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.get(path);
        this.myConnection.write("(w(ss(s)))", new Object[]{"change-file-prop", fileToken, name, value});
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.remove(path);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s(s)))", new Object[]{"close-file", fileToken, textChecksum});
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        SVNException e = null;
        try {
            this.myConnection.write("(w())", new Object[]{"close-edit"});
            this.myConnection.read("[()]", null, true);
            this.myRepository.authenticate();
            Object[] items = this.myConnection.read("(N(?S)(?S)", new Object[3], true);
            Object[] error = null;
            try {
                error = this.myConnection.read("(?S)", new Object[1], false);
            }
            catch (SVNException e2) {
                // empty catch block
            }
            this.myConnection.read(")", null, true);
            long revision = SVNReader.getLong(items, 0);
            Date date = SVNReader.getDate(items, 1);
            SVNErrorMessage err = null;
            if (error != null && error[0] != null && !"".equals(error[0])) {
                err = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, error[0].toString(), 1);
            }
            SVNCommitInfo sVNCommitInfo = new SVNCommitInfo(revision, (String)items[2], date, err);
            return sVNCommitInfo;
        }
        catch (SVNException exception) {
            e = exception;
            try {
                this.myConnection.write("(w())", new Object[]{"abort-edit"});
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.myCloseCallback.run(e);
            this.myCloseCallback = null;
        }
    }

    public void abortEdit() throws SVNException {
        if (this.myIsAborted || this.myCloseCallback == null) {
            return;
        }
        this.myIsAborted = true;
        SVNException error = null;
        try {
            this.myConnection.write("(w())", new Object[]{"abort-edit"});
            this.myConnection.read("[()]", null, true);
        }
        catch (SVNException e) {
            error = e;
            throw e;
        }
        finally {
            this.myCloseCallback.run(error);
            this.myCloseCallback = null;
        }
    }

    private static Long getRevisionObject(long rev) {
        return rev >= 0L ? new Long(rev) : null;
    }

    private class SVNDeltaStream
    extends OutputStream {
        private Object[] myPrefix;

        public SVNDeltaStream(String token) {
            this.myPrefix = new Object[]{"textdelta-chunk", token};
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                SVNCommitEditor.this.myConnection.write("(w(s", this.myPrefix);
                SVNCommitEditor.this.myConnection.getOutputStream().write((len + "").getBytes("UTF-8"));
                SVNCommitEditor.this.myConnection.getOutputStream().write(58);
                SVNCommitEditor.this.myConnection.getOutputStream().write(b, off, len);
                SVNCommitEditor.this.myConnection.getOutputStream().write(32);
                SVNCommitEditor.this.myConnection.write("))", null);
            }
            catch (SVNException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)});
        }
    }

    private static final class DirBaton {
        private String myToken;

        public DirBaton(int token) {
            this.myToken = "d" + token;
        }

        public String getToken() {
            return this.myToken;
        }
    }

    public static interface ISVNCommitCallback {
        public void run(SVNException var1);
    }
}

