/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.io.Serializable;
import java.util.Map;
import org.jitsi.utils.StringUtils;

public class StunServerDescriptor
implements Serializable {
    public static final int MAX_STUN_SERVER_COUNT = 100;
    public static final String PROTOCOL_UDP = "udp";
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_SSLTCP = "ssltcp";
    private String address;
    private int port;
    private boolean isTurnSupported;
    private boolean isOldTurn = false;
    private byte[] username;
    private byte[] password;
    private String protocol = "udp";

    public StunServerDescriptor(String address, int port, boolean supportTurn, String username, String password) {
        this.address = address;
        this.port = port;
        this.isTurnSupported = supportTurn;
        this.username = username != null ? StringUtils.getUTF8Bytes((String)username) : "".getBytes();
        this.password = password != null ? StringUtils.getUTF8Bytes((String)password) : "".getBytes();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isTurnSupported() {
        return this.isTurnSupported;
    }

    public void setTurnSupported(boolean turnSupported) {
        this.isTurnSupported = turnSupported;
    }

    public byte[] getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = StringUtils.getUTF8Bytes((String)username);
    }

    public byte[] getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.getUTF8Bytes((String)password);
    }

    public void storeDescriptor(Map<String, String> props, String namePrefix) {
        if (namePrefix == null) {
            namePrefix = "";
        }
        props.put(namePrefix + "ADDRESS", this.getAddress());
        if (this.getPort() != -1) {
            props.put(namePrefix + "PORT", Integer.toString(this.getPort()));
        }
        if (this.getUsername() != null && this.getUsername().length > 0) {
            props.put(namePrefix + "USERNAME", StringUtils.getUTF8String((byte[])this.getUsername()));
        }
        if (this.getPassword() != null && this.getPassword().length > 0) {
            props.put(namePrefix + "." + "PASSWORD", new String(this.getPassword()));
        }
        props.put(namePrefix + "IS_TURN_SUPPORTED", Boolean.toString(this.isTurnSupported()));
    }

    public static StunServerDescriptor loadDescriptor(Map<String, String> props, String namePrefix) {
        String stunAddress;
        if (namePrefix == null) {
            namePrefix = "";
        }
        if ((stunAddress = props.get(namePrefix + "ADDRESS")) == null) {
            return null;
        }
        String stunPortStr = props.get(namePrefix + "PORT");
        int stunPort = -1;
        try {
            stunPort = Integer.parseInt(stunPortStr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String stunUsername = props.get(namePrefix + "USERNAME");
        String stunPassword = props.get(namePrefix + "PASSWORD");
        boolean stunIsTurnSupported = Boolean.parseBoolean(props.get(namePrefix + "IS_TURN_SUPPORTED"));
        StunServerDescriptor stunServer = new StunServerDescriptor(stunAddress, stunPort, stunIsTurnSupported, stunUsername, stunPassword);
        return stunServer;
    }

    public boolean isOldTurn() {
        return this.isOldTurn;
    }

    public void setOldTurn(boolean val) {
        this.isOldTurn = val;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return "StunServerDesc: " + this.getAddress() + "/" + this.getPort() + " turnSupp=" + this.isTurnSupported();
    }
}

