/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.EditorConfig;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import com.github.shyiko.ktlint.ruleset.standard.ParameterListWrappingRule;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002Je\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102K\u0010\u0011\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\f\u0010\u0017\u001a\u00020\n*\u00020\u0006H\u0002J/\u0010\r\u001a\u00020\u000e*\u00020\f2!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/ParameterListWrappingRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "indentSize", "", "column", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getColumn", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;)I", "errorMessage", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "visit", "", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "canBeAutoCorrected", "lineIndent", "cb", "Lkotlin/Function1;", "ktlint-ruleset-standard"})
public final class ParameterListWrappingRule
extends Rule {
    private int indentSize = -1;

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.FILE)) {
            EditorConfig ec = EditorConfig.Companion.from((FileASTNode)node);
            this.indentSize = ec.getIndentSize();
            return;
        }
        if (this.indentSize <= 0) {
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.VALUE_PARAMETER_LIST)) {
            boolean putParametersOnSeparateLines;
            ASTNode aSTNode = node.getTreeParent();
            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.FUNCTION_LITERAL) ^ true && (putParametersOnSeparateLines = node.textContains('\n'))) {
                String indent = "\n" + this.lineIndent(node.getPsi());
                String paramIndent = indent + StringsKt.repeat((CharSequence)" ", (int)this.indentSize);
                for (ASTNode child : PsiUtilsKt.children((ASTNode)node)) {
                    void paramInnerIndentAdjustment;
                    LeafPsiElement prevLeaf;
                    String intendedIndent;
                    IElementType iElementType = child.getElementType();
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)KtStubElementTypes.VALUE_PARAMETER) && !Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RPAR)) continue;
                    Ref.IntRef intRef = new Ref.IntRef();
                    intRef.element = 0;
                    if (PackageKt.prevLeaf(child.getPsi()) == null) {
                        Intrinsics.throwNpe();
                    }
                    String string = intendedIndent = Intrinsics.areEqual((Object)child.getElementType(), (Object)KtStubElementTypes.VALUE_PARAMETER) ? paramIndent : indent;
                    if (Intrinsics.areEqual((Object)prevLeaf.getNode().getElementType(), (Object)KtTokens.WHITE_SPACE)) {
                        String string2;
                        String spacing = prevLeaf.getText();
                        int cut = StringsKt.lastIndexOf$default((CharSequence)spacing, (String)"\n", (int)0, (boolean)false, (int)6, null);
                        if (cut > -1) {
                            String childIndent;
                            String string3 = string2 = spacing;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(cut), (String)"(this as java.lang.String).substring(startIndex)");
                            if (Intrinsics.areEqual((Object)childIndent, (Object)intendedIndent)) continue;
                            emit.invoke((Object)child.getStartOffset(), (Object)("Unexpected indentation" + " (expected " + (intendedIndent.length() - 1) + ", actual " + (childIndent.length() - 1) + ')'), (Object)true);
                        } else {
                            emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                        }
                        if (autoCorrect) {
                            String string4;
                            StringBuilder stringBuilder = new StringBuilder();
                            if (cut > -1) {
                                String string5;
                                string2 = spacing;
                                int n = 0;
                                StringBuilder stringBuilder2 = stringBuilder;
                                String string6 = string2;
                                if (string6 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(n, cut), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                stringBuilder = stringBuilder2;
                                string4 = string5;
                            } else {
                                string4 = "";
                            }
                            String adjustedIndent = stringBuilder.append(string4).append(intendedIndent).toString();
                            paramInnerIndentAdjustment.element = adjustedIndent.length() - prevLeaf.getTextLength();
                            prevLeaf.rawReplaceWithText(adjustedIndent);
                        }
                    } else {
                        emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                        if (autoCorrect) {
                            paramInnerIndentAdjustment.element = intendedIndent.length() - this.getColumn(child.getPsi());
                            node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)intendedIndent), child);
                        }
                    }
                    if (paramInnerIndentAdjustment.element == 0 || !Intrinsics.areEqual((Object)child.getElementType(), (Object)KtStubElementTypes.VALUE_PARAMETER)) continue;
                    this.visit(child, (Function1<? super ASTNode, Unit>)((Function1)new Function1<ASTNode, Unit>((Ref.IntRef)paramInnerIndentAdjustment){
                        final /* synthetic */ Ref.IntRef $paramInnerIndentAdjustment;

                        public final void invoke(@NotNull ASTNode n) {
                            Intrinsics.checkParameterIsNotNull((Object)n, (String)"n");
                            if (Intrinsics.areEqual((Object)n.getElementType(), (Object)KtTokens.WHITE_SPACE) && n.textContains('\n')) {
                                List split = StringsKt.split$default((CharSequence)n.getText(), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
                                PsiElement psiElement = n.getPsi();
                                if (psiElement == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                                }
                                ((LeafElement)psiElement).rawReplaceWithText(CollectionsKt.joinToString$default((Iterable)split, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
                                    final /* synthetic */ visit.1 this$0;

                                    @NotNull
                                    public final CharSequence invoke(@NotNull String it) {
                                        CharSequence charSequence;
                                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                        if (this.this$0.$paramInnerIndentAdjustment.element > 0) {
                                            charSequence = it + StringsKt.repeat((CharSequence)" ", (int)this.this$0.$paramInnerIndentAdjustment.element);
                                        } else {
                                            String string = it;
                                            int n = 0;
                                            int n2 = Math.max(it.length() + this.this$0.$paramInnerIndentAdjustment.element, 0);
                                            String string2 = string.substring(n, n2);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                            charSequence = string2;
                                        }
                                        return charSequence;
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                }), (int)30, null));
                            }
                        }
                        {
                            this.$paramInnerIndentAdjustment = intRef;
                            super(1);
                        }
                    }));
                }
            }
        }
    }

    private final int getColumn(@NotNull PsiElement $receiver) {
        PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)$receiver);
        int offsetToTheLeft = 0;
        while (leaf != null) {
            if (Intrinsics.areEqual((Object)leaf.getNode().getElementType(), (Object)KtTokens.WHITE_SPACE) && leaf.textContains('\n')) {
                offsetToTheLeft += leaf.getTextLength() - 1 - StringsKt.lastIndexOf$default((CharSequence)leaf.getText(), (char)'\n', (int)0, (boolean)false, (int)6, null);
                break;
            }
            offsetToTheLeft += leaf.getTextLength();
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        return offsetToTheLeft + 1;
    }

    private final void visit(@NotNull ASTNode $receiver, Function1<? super ASTNode, Unit> cb) {
        cb.invoke((Object)$receiver);
        for (Object element$iv : (Object[])$receiver.getChildren(null)) {
            ASTNode it = (ASTNode)element$iv;
            this.visit(it, cb);
        }
    }

    private final String errorMessage(ASTNode node) {
        String string;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtStubElementTypes.VALUE_PARAMETER)) {
            string = "Parameter should be on a separate line (unless all parameters can fit a single line)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RPAR)) {
            string = "Missing newline before \")\"";
        } else {
            throw (Throwable)new UnsupportedOperationException();
        }
        return string;
    }

    private final String lineIndent(@NotNull PsiElement $receiver) {
        PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)$receiver);
        while (leaf != null) {
            if (Intrinsics.areEqual((Object)leaf.getNode().getElementType(), (Object)KtTokens.WHITE_SPACE) && leaf.textContains('\n')) {
                String string = leaf.getText();
                int n = StringsKt.lastIndexOf$default((CharSequence)leaf.getText(), (char)'\n', (int)0, (boolean)false, (int)6, null) + 1;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                return string3;
            }
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        return "";
    }

    public ParameterListWrappingRule() {
        super("parameter-list-wrapping");
    }
}

