/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.EditorConfig;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002Je\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\f\u0010\u0016\u001a\u00020\u0004*\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/IndentationRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "continuationIndentSize", "", "indentSize", "shouldUseContinuationIndent", "", "node", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiWhiteSpace;", "visit", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "previousIndentSize", "ktlint-ruleset-standard"})
public final class IndentationRule
extends Rule {
    private int indentSize = -1;
    private int continuationIndentSize = -1;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        List lines;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.FILE)) {
            EditorConfig ec = EditorConfig.Companion.from((FileASTNode)node);
            this.indentSize = ec.getIndentSize();
            this.continuationIndentSize = ec.getContinuationIndentSize();
            return;
        }
        if (this.indentSize <= 0 || this.continuationIndentSize <= 0) {
            return;
        }
        if (node instanceof PsiWhiteSpace && !PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class)) && (lines = StringsKt.split$default((CharSequence)node.getText(), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)).size() > 1) {
            int offset = node.getStartOffset() + ((String)CollectionsKt.first((List)lines)).length() + 1;
            int previousIndentSize = this.previousIndentSize(node);
            int expectedIndentSize = this.continuationIndentSize == this.indentSize || this.shouldUseContinuationIndent((PsiWhiteSpace)node) ? this.continuationIndentSize : this.indentSize;
            Iterable $receiver$iv = PackageKt.tail(lines);
            for (Object element$iv : $receiver$iv) {
                String indent = (String)element$iv;
                CharSequence charSequence = indent;
                if (charSequence.length() > 0 && (indent.length() - previousIndentSize) % expectedIndentSize != 0 && !PackageKt.isPartOf((PsiElement)node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtParameterList.class))) {
                    emit.invoke((Object)offset, (Object)("Unexpected indentation (" + indent.length() + ") (it should be " + (previousIndentSize + expectedIndentSize) + ')'), (Object)false);
                }
                offset += indent.length() + 1;
            }
        }
    }

    private final boolean shouldUseContinuationIndent(PsiWhiteSpace node) {
        PsiElement parentNode = node.getParent();
        PsiElement psiElement = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)node), (boolean)false, (int)1, null);
        IElementType prevNode = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null;
        PsiElement psiElement2 = node.getNextSibling();
        IElementType nextNode = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null;
        return KtTokens.ALL_ASSIGNMENTS.contains(prevNode) || parentNode instanceof KtSecondaryConstructor || Intrinsics.areEqual((Object)nextNode, (Object)KtStubElementTypes.TYPE_REFERENCE) || node.getNextSibling() instanceof KtSuperTypeList || node.getNextSibling() instanceof KtSuperTypeListEntry || node.getNextSibling() instanceof KtTypeProjection || parentNode instanceof KtValueArgumentList || parentNode instanceof KtBinaryExpression || parentNode instanceof KtDotQualifiedExpression || parentNode instanceof KtSafeQualifiedExpression || parentNode instanceof KtParenthesizedExpression;
    }

    private final int previousIndentSize(@NotNull ASTNode $receiver) {
        PsiElement node;
        ASTNode aSTNode = $receiver.getTreeParent();
        Object object = node = aSTNode != null ? aSTNode.getPsi() : null;
        while (node != null) {
            PsiElement psiElement;
            IElementType nextNode;
            PsiElement psiElement2 = node.getNextSibling();
            IElementType iElementType = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : (nextNode = null);
            if (node instanceof PsiWhiteSpace && Intrinsics.areEqual((Object)nextNode, (Object)KtStubElementTypes.TYPE_REFERENCE) ^ true && Intrinsics.areEqual((Object)nextNode, (Object)KtStubElementTypes.SUPER_TYPE_LIST) ^ true && Intrinsics.areEqual((Object)nextNode, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL) ^ true && node.textContains('\n')) {
                LeafPsiElement leafPsiElement = PackageKt.nextLeaf(node);
                if (leafPsiElement == null || !PackageKt.isPartOf((PsiElement)leafPsiElement, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                    return ((PsiWhiteSpace)node).getText().length() - StringsKt.lastIndexOf$default((CharSequence)((PsiWhiteSpace)node).getText(), (char)'\n', (int)0, (boolean)false, (int)6, null) - 1;
                }
            }
            if ((psiElement = node.getPrevSibling()) == null) {
                psiElement = node.getParent();
            }
            node = psiElement;
        }
        return 0;
    }

    public IndentationRule() {
        super("indent");
    }
}

