/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/ImportOrderingRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class ImportOrderingRule
extends Rule {
    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        ASTNode[] children;
        Object[] objectArray;
        Object[] objectArray2;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtStubElementTypes.IMPORT_LIST) && !((objectArray2 = (objectArray = (Object[])(children = node.getChildren(null)))).length == 0)) {
            void $receiver$iv$iv;
            Object[] $receiver$iv;
            Object[] objectArray3 = $receiver$iv = (Object[])children;
            Iterable<void> destination$iv$iv = new ArrayList();
            for (ASTNode element$iv$iv : $receiver$iv$iv) {
                ASTNode it = element$iv$iv;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)KtStubElementTypes.IMPORT_DIRECTIVE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List imports = (List)destination$iv$iv;
            Iterable $receiver$iv2 = imports;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    ASTNode it = (ASTNode)a;
                    Comparable comparable = (Comparable)((Object)it.getText());
                    it = (ASTNode)b;
                    Comparable comparable2 = comparable;
                    String string = it.getText();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            List sortedImports = CollectionsKt.sortedWith(destination$iv$iv = $receiver$iv2, (Comparator)comparator);
            if (Intrinsics.areEqual((Object)imports, (Object)sortedImports) ^ true) {
                emit.invoke((Object)node.getStartOffset(), (Object)"Imports must be ordered in lexicographic order", (Object)true);
                if (autoCorrect) {
                    node.removeRange(node.getFirstChildNode(), node.getLastChildNode().getTreeNext());
                    $receiver$iv2 = sortedImports;
                    int index$iv = 0;
                    for (Object item$iv : $receiver$iv2) {
                        void astNode;
                        ASTNode element$iv$iv;
                        int n = index$iv++;
                        element$iv$iv = (ASTNode)item$iv;
                        int i = n;
                        if (i > 0) {
                            node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
                        }
                        node.addChild((ASTNode)astNode, null);
                    }
                }
            }
        }
    }

    public ImportOrderingRule() {
        super("import-ordering");
    }
}

